/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.chapter;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.ChapterManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.chapter.ChaptersScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EditScreenChapterAdapter
implements EditScreenAdapter<Chapter> {
    @Override
    public void initExtraFields(EditInfoScreen<Chapter> screen, Chapter entry) {
    }

    @Override
    public void renderExtraFields(EditInfoScreen<Chapter> screen, Chapter entry, int startY, int centerX) {
    }

    @Override
    public void buildFromScreen(Map<String, Object> extraFields, Minecraft minecraft, @Nullable Chapter existing, String name, String description) {
        if (existing == null) {
            ChapterManager chapterManager = NarrativeCraftMod.getInstance().getChapterManager();
            if (chapterManager.chapterExists(name)) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("chapter.already_exists", name));
                return;
            }
            Chapter chapter = new Chapter(name, description, chapterManager.getChapters().size() + 1);
            try {
                chapterManager.addChapter(chapter);
                NarrativeCraftFile.createChapterDirectory(chapter);
                minecraft.m_91152_((Screen)new ChaptersScreen());
            }
            catch (Exception e) {
                chapterManager.removeChapter(chapter);
                Util.sendCrashMessage((Player)minecraft.f_91074_, e);
                minecraft.m_91152_(null);
            }
        } else {
            Chapter newChapter = new Chapter(name, description, existing.getIndex());
            Chapter oldChapter = new Chapter(existing.getName(), existing.getDescription(), existing.getIndex());
            try {
                NarrativeCraftFile.updateChapterData(newChapter);
                existing.setName(name);
                existing.setDescription(description);
                NarrativeCraftFile.updateInkIncludes();
                minecraft.m_91152_((Screen)new ChaptersScreen());
            }
            catch (Exception e) {
                existing.setName(oldChapter.getName());
                existing.setDescription(oldChapter.getDescription());
                Util.sendCrashMessage((Player)minecraft.f_91074_, e);
                minecraft.m_91152_(null);
            }
        }
    }
}

