/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.mainScreen;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.controllers.cutscene.CutscenePlayback;
import fr.loudo.narrativecraft.controllers.mainScreen.MainScreenController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.data.MainScreenData;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.narrative.story.StorySave;
import fr.loudo.narrativecraft.narrative.story.StoryValidation;
import fr.loudo.narrativecraft.options.NarrativeWorldOption;
import fr.loudo.narrativecraft.screens.components.ChapterSelectorScreen;
import fr.loudo.narrativecraft.screens.components.CrashScreen;
import fr.loudo.narrativecraft.screens.components.FinishedStoryScreen;
import fr.loudo.narrativecraft.screens.components.NarrativeCraftLogoRenderer;
import fr.loudo.narrativecraft.screens.mainScreen.MainScreenOptionsScreen;
import fr.loudo.narrativecraft.screens.story.StoryChoicesScreen;
import fr.loudo.narrativecraft.util.ErrorLine;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_9848;

public class MainScreen
extends class_437 {
    public static final class_2960 BACKGROUND_IMAGE = class_2960.method_60656((String)"textures/narrativecraft_mainscreen/background.png");
    public static final class_2960 MUSIC = class_2960.method_60656((String)"narrativecraft_mainscreen.music");
    public static class_1109 musicInstance = new class_1109(MUSIC, class_3419.field_15250, 0.7f, 1.0f, class_1113.method_43221(), true, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true);
    private final NarrativeCraftLogoRenderer narrativeCraftLogo = NarrativeCraftMod.getInstance().getNarrativeCraftLogoRenderer();
    private final PlayerSession playerSession;
    private final int buttonWidth = 100;
    private final int buttonHeight = 20;
    private final int initialX = 50;
    private final int gap = 5;
    private int initialY;
    private int showDevBtnCount;
    private class_4185 devButton;
    private final boolean finishedStory;
    private final boolean pause;
    private boolean rendered;
    private int userFloodedKeyboard;

    public MainScreen(PlayerSession playerSession, boolean finishedStory, boolean pause) {
        super((class_2561)class_2561.method_43470((String)"Main screen"));
        this.finishedStory = finishedStory;
        this.pause = pause;
        this.playerSession = playerSession;
        this.userFloodedKeyboard = 0;
    }

    private void playStory() {
        this.method_25419();
        StoryHandler storyHandler = new StoryHandler(this.playerSession);
        this.field_22787.method_1483().method_4870((class_1113)musicInstance);
        try {
            List<ErrorLine> errorLines = StoryValidation.validate();
            if (errorLines.stream().map(ErrorLine::isWarn).toList().isEmpty()) {
                NarrativeCraftMod.server.execute(storyHandler::start);
            } else {
                NarrativeCraftMod.LOGGER.error(" ");
                NarrativeCraftMod.LOGGER.error("Story can't start: ");
                for (ErrorLine errorLine : errorLines) {
                    NarrativeCraftMod.LOGGER.error("{} {} {}", new Object[]{errorLine.getFileName(), errorLine.getLineText(), errorLine.getMessage()});
                }
                NarrativeCraftMod.LOGGER.error(" ");
                CrashScreen crashScreen = new CrashScreen(this.playerSession, Translation.message("validation.from_main_screen", new Object[0]).getString());
                this.field_22787.method_1507((class_437)crashScreen);
            }
        }
        catch (Exception e) {
            CrashScreen crashScreen = new CrashScreen(this.playerSession, e.getMessage());
            this.field_22787.method_1507((class_437)crashScreen);
        }
    }

    public void method_25419() {
        super.method_25419();
        if (!this.pause) {
            this.field_22787.method_1483().method_4870((class_1113)musicInstance);
            this.field_22787.field_1690.field_1842 = false;
            if (this.playerSession.getController() != null) {
                NarrativeCraftMod.server.execute(() -> this.playerSession.getController().stopSession(false));
            }
        } else {
            StoryHandler storyHandler = this.playerSession.getStoryHandler();
            if (storyHandler != null && !storyHandler.getStory().getCurrentChoices().isEmpty()) {
                StoryChoicesScreen choicesScreen = new StoryChoicesScreen(storyHandler.getStory().getCurrentChoices(), false);
                this.field_22787.method_1507((class_437)choicesScreen);
            }
        }
    }

    protected void method_25426() {
        int totalButtons;
        boolean firstGame;
        boolean storyFinished = NarrativeCraftMod.getInstance().getNarrativeWorldOption().finishedStory;
        this.field_22787.field_1690.field_1842 = true;
        this.showDevBtnCount = 0;
        StorySave save = null;
        try {
            save = NarrativeCraftFile.saveContent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = firstGame = save == null;
        if (!this.pause && this.playerSession.getController() == null) {
            try {
                MainScreenData mainScreenData = NarrativeCraftFile.getMainScreenBackground();
                MainScreenController mainScreenController = new MainScreenController(Environment.PRODUCTION, (class_1657)this.field_22787.field_1724, mainScreenData);
                NarrativeCraftMod.server.execute(mainScreenController::startSession);
            }
            catch (Exception mainScreenData) {
                // empty catch block
            }
        }
        if (!this.pause && !this.rendered) {
            this.field_22787.method_1483().method_4873((class_1113)musicInstance);
            this.rendered = true;
        }
        int n = totalButtons = storyFinished ? 5 : 4;
        if (this.pause) {
            totalButtons = 5;
        }
        int totalHeight = 20 * totalButtons + 5 * (totalButtons - 1);
        this.initialY = this.field_22790 / 2 - totalHeight / 2;
        if (this.narrativeCraftLogo.logoExists()) {
            this.initialY += this.narrativeCraftLogo.getImageHeight() / 2 + 5;
        }
        int startY = this.initialY;
        class_5250 playBtnComponent = firstGame && !this.pause ? Translation.message("screen.main_screen.play", new Object[0]) : Translation.message("screen.main_screen.continue", new Object[0]);
        boolean canPlay = !NarrativeCraftMod.getInstance().getChapterManager().getChapters().isEmpty();
        class_4185 playButton = class_4185.method_46430((class_2561)playBtnComponent, button -> {
            if (this.pause) {
                this.method_25419();
            } else {
                this.playStory();
            }
        }).method_46434(50, startY, 100, 20).method_46431();
        playButton.field_22763 = canPlay;
        if (!canPlay) {
            playButton.method_47400(class_7919.method_47407((class_2561)Translation.message("screen.main_screen.cant_play_tooltip", new Object[0])));
        }
        this.method_37063((class_364)playButton);
        if (!firstGame && !this.pause) {
            class_4185 startNewGame = class_4185.method_46430((class_2561)Translation.message("screen.main_screen.new_game", new Object[0]), button -> {
                class_410 confirmScreen = new class_410(b -> {
                    if (b) {
                        NarrativeWorldOption option = NarrativeCraftMod.getInstance().getNarrativeWorldOption();
                        NarrativeCraftFile.removeSave();
                        option.finishedStory = false;
                        NarrativeCraftFile.updateWorldOptions(option);
                        this.playStory();
                    } else {
                        this.field_22787.method_1507((class_437)this);
                    }
                }, (class_2561)class_2561.method_43470((String)""), (class_2561)Translation.message("screen.main_screen.new_game.confirm", new Object[0]), class_5244.field_24336, class_5244.field_24335);
                this.field_22787.method_1507((class_437)confirmScreen);
            }).method_46434(50, startY += 25, 100, 20).method_46431();
            startNewGame.field_22763 = canPlay;
            if (!canPlay) {
                startNewGame.method_47400(class_7919.method_47407((class_2561)Translation.message("screen.main_screen.cant_play_tooltip", new Object[0])));
            }
            this.method_37063((class_364)startNewGame);
        }
        if (!this.pause && NarrativeCraftMod.getInstance().getNarrativeWorldOption().finishedStory) {
            class_4185 selectSceneButton = class_4185.method_46430((class_2561)Translation.message("screen.main_screen.select_screen", new Object[0]), button -> {
                this.field_22787.method_1483().method_4870((class_1113)musicInstance);
                ChapterSelectorScreen screen = new ChapterSelectorScreen(this.playerSession, this);
                this.field_22787.method_1507((class_437)screen);
            }).method_46434(50, startY += 25, 100, 20).method_46431();
            this.method_37063((class_364)selectSceneButton);
        }
        if (this.pause) {
            class_4185 loadLastSaveButton = class_4185.method_46430((class_2561)Translation.message("screen.main_screen.pause.load_last_save", new Object[0]), button -> {
                this.field_22787.method_1507(null);
                StoryHandler storyHandler = new StoryHandler(this.playerSession);
                storyHandler.setDebugMode(this.playerSession.getStoryHandler().isDebugMode());
                NarrativeCraftMod.server.execute(() -> {
                    this.playerSession.getStoryHandler().stop();
                    storyHandler.start();
                });
            }).method_46434(50, startY += 25, 100, 20).method_46431();
            this.method_37063((class_364)loadLastSaveButton);
            AbstractController controller = this.playerSession.getController();
            class_4185 skipCutsceneButton = class_4185.method_46430((class_2561)Translation.message("screen.main_screen.pause.skip_cutscene", new Object[0]), button -> {
                CutsceneController cutsceneController;
                CutscenePlayback cutscenePlayback;
                this.field_22787.method_1507(null);
                if (controller instanceof CutsceneController && (cutscenePlayback = (cutsceneController = (CutsceneController)controller).getCutscenePlayback()) != null) {
                    cutscenePlayback.skip();
                }
            }).method_46434(50, startY += 25, 100, 20).method_46431();
            skipCutsceneButton.field_22763 = controller instanceof CutsceneController && controller != null;
            this.method_37063((class_364)skipCutsceneButton);
        }
        class_4185 optionsButton = class_4185.method_46430((class_2561)Translation.message("screen.main_screen.options", new Object[0]), button -> {
            this.field_22787.method_1483().method_4870((class_1113)musicInstance);
            MainScreenOptionsScreen screen = new MainScreenOptionsScreen(this.playerSession, new MainScreen(this.playerSession, false, this.pause));
            this.field_22787.method_1507((class_437)screen);
        }).method_46434(50, startY += 25, 100, 20).method_46431();
        this.method_37063((class_364)optionsButton);
        if (this.pause) {
            quitButton = class_4185.method_46430((class_2561)Translation.message("screen.main_screen.pause.leave", new Object[0]), button -> NarrativeCraftMod.server.execute(() -> {
                this.playerSession.getStoryHandler().stop();
                MainScreen mainScreen = new MainScreen(this.playerSession, false, false);
                this.field_22787.execute(() -> this.field_22787.method_1507((class_437)mainScreen));
            })).method_46434(50, startY += 25, 100, 20).method_46431();
            this.method_37063((class_364)quitButton);
        } else {
            quitButton = class_4185.method_46430((class_2561)Translation.message("screen.main_screen.quit", new Object[0]), button -> Util.disconnectPlayer(this.field_22787)).method_46434(50, startY += 25, 100, 20).method_46431();
            this.method_37063((class_364)quitButton);
        }
        this.devButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Dev Environment"), button -> {
            this.field_22787.field_1724.method_7353((class_2561)Translation.message("global.dev_env", new Object[0]), false);
            this.method_25419();
        }).method_46434(this.field_22789 - 100 - 10, 20, 100, 20).method_46431();
        if (this.finishedStory) {
            FinishedStoryScreen screen = new FinishedStoryScreen(this.playerSession);
            this.field_22787.method_1507((class_437)screen);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.narrativeCraftLogo.logoExists()) {
            this.narrativeCraftLogo.render(guiGraphics, 50, this.initialY - this.narrativeCraftLogo.getImageHeight() - 5 - 5);
        }
        if (NarrativeCraftMod.getInstance().getChapterManager().getChapters().isEmpty() || this.userFloodedKeyboard > 20) {
            guiGraphics.method_25303(this.field_22787.field_1772, Translation.message("screen.main_screen.dev_tip", new Object[0]).getString(), guiGraphics.method_51421() / 2 - this.field_22787.field_1772.method_27525((class_5348)Translation.message("screen.main_screen.dev_tip", new Object[0])) / 2, 20, class_9848.method_61318((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.pause) {
            super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
            return;
        }
        if (this.playerSession.getController() != null) {
            return;
        }
        if (Util.resourceExists(BACKGROUND_IMAGE)) {
            guiGraphics.method_25291(class_10799.field_56883, BACKGROUND_IMAGE, 0, 0, 0.0f, 0.0f, guiGraphics.method_51421(), guiGraphics.method_51443(), guiGraphics.method_51421(), guiGraphics.method_51443(), class_9848.method_61318((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
        } else {
            guiGraphics.method_25294(0, 0, guiGraphics.method_51421(), guiGraphics.method_51443(), class_9848.method_61318((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        }
    }

    protected void method_57734(class_332 guiGraphics) {
    }

    public boolean method_25421() {
        return this.pause;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.pause) {
            ++this.userFloodedKeyboard;
        }
        if (keyCode == 341 && !this.pause) {
            ++this.showDevBtnCount;
            if (this.showDevBtnCount == 5) {
                this.method_37063((class_364)this.devButton);
            }
        }
        if (keyCode == 256 && !this.pause) {
            return false;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

