/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.character;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.CharacterManager;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.screens.characters.CharacterEntityTypeScreen;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.character.EditScreenCharacterAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class CharactersScreen
extends StoryElementScreen {
    private final Scene scene;

    public CharactersScreen(Scene scene) {
        super((class_2561)(scene == null ? Translation.message("screen.story_manager.characters", new Object[0]) : Translation.message("screen.story_manager.npcs", scene.getName())));
        this.scene = scene;
    }

    public void method_25419() {
        if (this.scene != null) {
            this.field_22787.method_1507((class_437)new ScenesMenuScreen(this.scene));
        } else {
            super.method_25419();
        }
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<CharacterStory> screen = new EditInfoScreen<CharacterStory>(this, null, new EditScreenCharacterAdapter(this.scene));
            this.field_22787.method_1507(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addContents() {
        CharacterManager characterManager = NarrativeCraftMod.getInstance().getCharacterManager();
        List<CharacterStory> characterStories = this.scene == null ? characterManager.getCharacterStories() : this.scene.getNpcs();
        List<StoryElementList.StoryEntryData> entries = characterStories.stream().map(character -> {
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)character.getName()), button1 -> {}).method_46431();
            button.field_22763 = false;
            class_4185 entityTypeButton = class_4185.method_46430((class_2561)ImageFontConstants.ENTITY, button1 -> {
                CharacterEntityTypeScreen screen = new CharacterEntityTypeScreen(this, (CharacterStory)character);
                this.field_22787.method_1507((class_437)screen);
            }).method_46431();
            entityTypeButton.method_47400(class_7919.method_47407((class_2561)Translation.message("tooltip.character_entity_type", new Object[0])));
            return new StoryElementList.StoryEntryData(button, List.of(entityTypeButton), () -> this.field_22787.method_1507(new EditInfoScreen<CharacterStory>(this, (CharacterStory)character, new EditScreenCharacterAdapter(this.scene))), () -> {
                if (this.scene == null) {
                    characterManager.removeCharacter((CharacterStory)character);
                    NarrativeCraftFile.deleteCharacterFolder(character);
                } else {
                    this.scene.removeNpc((CharacterStory)character);
                    NarrativeCraftFile.deleteCharacterFolder(character, this.scene);
                }
                this.field_22787.method_1507((class_437)new CharactersScreen(this.scene));
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.method_48999((class_8021)new StoryElementList(this.field_22787, this, entries, true));
    }

    @Override
    protected void openFolder() {
        if (this.scene == null) {
            class_156.method_668().method_60932(NarrativeCraftFile.characterDirectory.toPath());
        } else {
            class_156.method_668().method_60932(NarrativeCraftFile.getNpcFolder(this.scene).toPath());
        }
    }
}

