/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.scene;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.chapter.ChaptersScreen;
import fr.loudo.narrativecraft.screens.storyManager.scene.EditScreenSceneAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8021;

public class ScenesScreen
extends StoryElementScreen {
    private final Chapter chapter;

    public ScenesScreen(Chapter chapter) {
        super((class_2561)Translation.message("screen.story_manager.scene_list", chapter.getIndex()));
        this.chapter = chapter;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<Scene> screen = new EditInfoScreen<Scene>(this, null, new EditScreenSceneAdapter(this.chapter));
            this.field_22787.method_1507(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24339, p_345997_ -> this.method_25419()).method_46432(200).method_46431());
    }

    public void method_25419() {
        ChaptersScreen screen = new ChaptersScreen();
        this.field_22787.method_1507((class_437)screen);
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.chapter.getSortedSceneList().stream().map(scene -> {
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)scene.getName()), b -> this.field_22787.method_1507((class_437)new ScenesMenuScreen((Scene)scene))).method_46431();
            return new StoryElementList.StoryEntryData(button, () -> this.field_22787.method_1507(new EditInfoScreen<Scene>(this, (Scene)scene, new EditScreenSceneAdapter(this.chapter))), () -> {
                try {
                    this.chapter.removeScene((Scene)scene);
                    NarrativeCraftFile.deleteSceneDirectory(scene);
                    if (scene.getRank() == 1 && this.chapter.getSortedSceneList().size() > 1) {
                        NarrativeCraftFile.updateMasterSceneKnot(this.chapter.getSortedSceneList().getFirst());
                    }
                    this.field_22787.method_1507((class_437)new ScenesScreen(this.chapter));
                }
                catch (Exception e) {
                    this.chapter.addScene((Scene)scene);
                    this.chapter.setSceneRank((Scene)scene, scene.getRank());
                    Util.sendCrashMessage((class_1657)this.field_22787.field_1724, e);
                    this.field_22787.method_1507(null);
                }
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.method_48999((class_8021)new StoryElementList(this.field_22787, this, entries, true));
    }

    @Override
    protected void openFolder() {
        class_156.method_668().method_60932(NarrativeCraftFile.getScenesFolder(this.chapter).toPath());
    }
}

