/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_9848;

public abstract class AbstractController {
    protected final Environment environment;
    protected final PlayerSession playerSession;
    protected String hudMessage;

    public AbstractController(Environment environment, class_1657 player) {
        this.environment = environment;
        this.playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer(player);
    }

    public abstract void startSession();

    public abstract void stopSession(boolean var1);

    public abstract class_437 getControllerScreen();

    protected void stopCurrentSession() {
        AbstractController controller = this.playerSession.getController();
        if (controller == null) {
            return;
        }
        controller.stopSession(false);
    }

    public void renderHUDInfo(class_332 guiGraphics) {
        if (this.playerSession.getCurrentCamera() != null || this.environment != Environment.DEVELOPMENT) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        int width = minecraft.method_22683().method_4486();
        guiGraphics.method_25303(font, this.hudMessage, width / 2 - font.method_1727(this.hudMessage) / 2, 10, class_9848.method_61318((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public PlayerSession getPlayerSession() {
        return this.playerSession;
    }
}

