/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3541;
import net.minecraft.class_4587;
import net.minecraft.class_5819;

public class ShakeScreenInkAction
extends InkAction {
    private static final float PIXEL = 0.025f;
    private float noiseShakeSpeed;
    private float noiseShakeStrength;
    private float shakeDecayRate;
    private class_3541 noise;
    private float noiseI = 0.0f;
    private float shakeStrength = 0.0f;
    private float lastOffsetX = 0.0f;
    private float lastOffsetY = 0.0f;
    private float currentOffsetX = 0.0f;
    private float currentOffsetY = 0.0f;

    public ShakeScreenInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void stop() {
        super.stop();
        this.shakeStrength = 0.0f;
        this.lastOffsetY = 0.0f;
        this.lastOffsetX = 0.0f;
        this.currentOffsetY = 0.0f;
        this.currentOffsetX = 0.0f;
        this.noiseI = 0.0f;
    }

    @Override
    public void tick() {
        if (!this.isRunning) {
            return;
        }
        this.noiseI += 0.05f * this.noiseShakeSpeed;
        this.shakeStrength = class_3532.method_16439((float)(this.shakeDecayRate * 0.05f), (float)this.shakeStrength, (float)0.0f);
        this.lastOffsetX = this.currentOffsetX;
        this.lastOffsetY = this.currentOffsetY;
        this.currentOffsetX = (float)this.noise.method_15433(1.0, (double)this.noiseI) * this.shakeStrength;
        this.currentOffsetY = (float)this.noise.method_15433(100.0, (double)this.noiseI) * this.shakeStrength;
        if (Math.abs(this.shakeStrength) <= 0.0f) {
            this.isRunning = false;
            this.lastOffsetY = 0.0f;
            this.lastOffsetX = 0.0f;
            this.currentOffsetY = 0.0f;
            this.currentOffsetX = 0.0f;
        }
    }

    @Override
    public void render(class_4587 poseStack, float partialTick) {
        float interpolatedX = class_3532.method_16439((float)partialTick, (float)this.lastOffsetX, (float)this.currentOffsetX);
        float interpolatedY = class_3532.method_16439((float)partialTick, (float)this.lastOffsetY, (float)this.currentOffsetY);
        poseStack.method_46416(interpolatedX, interpolatedY, 0.0f);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() == 1) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Shake strength"));
        }
        if (arguments.size() == 2) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Shake decay rate"));
        }
        if (arguments.size() == 3) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Shake speed"));
        }
        try {
            this.noiseShakeStrength = Float.parseFloat(arguments.get(1));
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(1)));
        }
        try {
            this.shakeDecayRate = Float.parseFloat(arguments.get(2));
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(2)));
        }
        try {
            this.noiseShakeSpeed = Float.parseFloat(arguments.get(3));
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(3)));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof ShakeScreenInkAction);
        if (this.noShaking()) {
            this.isRunning = false;
            return InkActionResult.ok();
        }
        this.noise = new class_3541(class_5819.method_43047());
        this.shakeStrength = this.noiseShakeStrength * 0.025f;
        this.noiseI = 0.0f;
        this.currentOffsetY = 0.0f;
        this.currentOffsetX = 0.0f;
        this.lastOffsetY = 0.0f;
        this.lastOffsetX = 0.0f;
        return InkActionResult.ok();
    }

    private boolean noShaking() {
        return this.noiseShakeStrength == 0.0f && this.shakeDecayRate == 0.0f && this.noiseShakeSpeed == 0.0f;
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

