/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.recording.Recording;
import fr.loudo.narrativecraft.narrative.recording.RecordingData;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionDifferenceListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractBoat.class})
public abstract class AbstractBoatMixin {
    @Shadow
    protected abstract int getBubbleTime();

    @Shadow
    public abstract boolean getPaddleState(int var1);

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void narrativecraft$boatTick(CallbackInfo ci) {
        if (NarrativeCraftMod.server == null) {
            return;
        }
        for (ServerPlayer player : NarrativeCraftMod.server.getPlayerList().getPlayers()) {
            Recording recording = NarrativeCraftMod.getInstance().getRecordingManager().getRecording((Entity)player);
            if (recording == null || !recording.isRecording()) {
                return;
            }
            AbstractBoat boat = (AbstractBoat)this;
            RecordingData recordingData = recording.getRecordingDataFromEntity((Entity)boat);
            if (recordingData == null || boat.level().isClientSide) {
                return;
            }
            ActionDifferenceListener actionDifferenceListener = recordingData.getActionDifferenceListener();
            actionDifferenceListener.abstractBoatEntityBubbleListener(this.getBubbleTime());
            actionDifferenceListener.abstractBoatEntityPaddleListener(this.getPaddleState(0), this.getPaddleState(1));
        }
    }
}

