/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import com.bladecoder.ink.runtime.Choice;
import fr.loudo.narrativecraft.gui.ICustomGuiRender;
import fr.loudo.narrativecraft.narrative.story.text.ParsedDialog;
import fr.loudo.narrativecraft.narrative.story.text.TextEffectAnimation;
import fr.loudo.narrativecraft.util.Util;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import org.joml.Vector2f;

public class ChoiceButtonWidget
extends AbstractButton {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final int index;
    private final int paddingX;
    private final int paddingY;
    private final int hoverWidth;
    private final boolean hoverBorder;
    private final Consumer<Integer> onPress;
    private int backgroundColor;
    private int textColor;
    private int hoverColor;
    private final ParsedDialog parsedDialog;
    private final TextEffectAnimation textEffectAnimation;
    private boolean canPress;

    public ChoiceButtonWidget(Choice choice, Consumer<Integer> onPress) {
        super(0, 0, 0, 0, (Component)Component.literal((String)choice.getText()));
        Font font = Minecraft.getInstance().font;
        this.onPress = onPress;
        String choiceString = this.getMessage().getString();
        this.index = choice.getIndex();
        this.paddingX = 9;
        this.paddingY = 6;
        this.backgroundColor = 0;
        this.textColor = 0xFFFFFF;
        this.hoverColor = 0xFFFFFF;
        this.hoverBorder = true;
        this.hoverWidth = 1;
        this.canPress = true;
        this.parsedDialog = ParsedDialog.parse(choiceString);
        int width = font.width(this.parsedDialog.cleanedText());
        Objects.requireNonNull(font);
        int height = 9;
        this.setWidth(width + this.paddingX * 2);
        this.setHeight(height + this.paddingY * 2);
        this.textEffectAnimation = new TextEffectAnimation(choiceString);
    }

    public void tick() {
        this.textEffectAnimation.tick();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int left = this.getX();
        int top = this.getY();
        int right = left + this.getWidth();
        int bottom = top + this.getHeight();
        if (this.isHovered && this.hoverBorder && this.canPress) {
            guiGraphics.fill(left - this.hoverWidth, top - this.hoverWidth, right + this.hoverWidth, bottom + this.hoverWidth, this.hoverColor);
        }
        guiGraphics.fill(left, top, right, bottom, this.backgroundColor);
        Map<Integer, Vector2f> letterOffsets = this.textEffectAnimation.getOffsets(partialTick);
        float startX = left + this.paddingX;
        for (int i = 0; i < this.parsedDialog.cleanedText().length(); ++i) {
            Vector2f offset = letterOffsets.getOrDefault(i, new Vector2f(0.0f, 0.0f));
            String character = String.valueOf(this.parsedDialog.cleanedText().charAt(i));
            ((ICustomGuiRender)guiGraphics).narrativecraft$drawStringFloat(character, Minecraft.getInstance().font, startX + offset.x, (float)(top + this.paddingY + 1) + offset.y, this.textColor, false);
            startX += Util.getLetterWidth(this.parsedDialog.cleanedText().codePointAt(i), this.minecraft);
        }
    }

    public void onPress() {
        if (!this.canPress) {
            return;
        }
        this.onPress.accept(this.index);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible) {
            boolean flag;
            if (this.isValidClickButton(button) && (flag = this.isMouseOver(mouseX, mouseY))) {
                this.onClick(mouseX, mouseY);
                return true;
            }
            return false;
        }
        return false;
    }

    public void setOpacity(int opacity) {
        this.backgroundColor = ARGB.color((int)opacity, (int)this.backgroundColor);
        this.textColor = ARGB.color((int)opacity, (int)this.textColor);
        this.hoverColor = ARGB.color((int)opacity, (int)this.hoverColor);
    }

    public boolean isCanPress() {
        return this.canPress;
    }

    public void setCanPress(boolean canPress) {
        this.canPress = canPress;
    }
}

