/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionType;
import fr.loudo.narrativecraft.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class BreakBlockAction
extends Action {
    private int x;
    private int y;
    private int z;
    private String data;

    public BreakBlockAction(int tick, BlockPos blockPos, BlockState blockState) {
        super(tick, ActionType.BLOCK_BREAK);
        this.x = blockPos.getX();
        this.y = blockPos.getY();
        this.z = blockPos.getZ();
        this.data = NbtUtils.writeBlockState((BlockState)blockState).toString();
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public String getData() {
        return this.data;
    }

    @Override
    public void execute(PlaybackData playbackData) {
        BlockPos blockPos = new BlockPos(this.x, this.y, this.z);
        BlockState blockState = Util.getBlockStateFromData(this.data, playbackData.getEntity().registryAccess());
        if (blockState != null) {
            if (blockState.getBlock() instanceof BedBlock) {
                if (blockState.getValue((Property)BedBlock.PART) == BedPart.FOOT) {
                    Direction direction = (Direction)blockState.getValue((Property)BedBlock.FACING);
                    blockPos = blockPos.relative(direction);
                }
            } else if (blockState.getBlock() instanceof DoorBlock && blockState.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER) {
                blockPos = blockPos.below();
            }
        }
        playbackData.getLevel().destroyBlock(blockPos, false);
    }

    @Override
    public void rewind(PlaybackData playbackData) {
        if (!(playbackData.getEntity() instanceof LivingEntity)) {
            return;
        }
        BlockState blockState = Util.getBlockStateFromData(this.data, playbackData.getEntity().registryAccess());
        if (blockState == null) {
            return;
        }
        BlockPos blockPos = new BlockPos(this.x, this.y, this.z);
        Block block = blockState.getBlock();
        if (block instanceof DoorBlock) {
            if (blockState.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER) {
                blockState = (BlockState)blockState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                blockPos = blockPos.below();
            }
        } else if (blockState.getBlock() instanceof BedBlock && blockState.getValue((Property)BedBlock.PART) == BedPart.HEAD) {
            Direction direction = (Direction)blockState.getValue((Property)BedBlock.FACING);
            blockState = (BlockState)blockState.setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
            blockPos = blockPos.relative(direction.getOpposite());
        }
        playbackData.getLevel().setBlock(blockPos, blockState, 3);
        if (block instanceof BedBlock || block instanceof DoorBlock) {
            block.setPlacedBy(playbackData.getEntity().level(), blockPos, blockState, (LivingEntity)playbackData.getEntity(), blockState.getBlock().asItem().getDefaultInstance());
        }
    }
}

