/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.text;

import fr.loudo.narrativecraft.narrative.dialog.DialogAnimationType;
import fr.loudo.narrativecraft.narrative.dialog.DialogLetterEffect;
import fr.loudo.narrativecraft.narrative.story.text.ParsedDialog;
import fr.loudo.narrativecraft.narrative.story.text.TextEffect;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.joml.Vector2f;

public class TextEffectAnimation {
    private final List<DialogLetterEffect> dialogLetterEffectList;
    private final Map<Integer, Vector2f> letterOffsets = new HashMap<Integer, Vector2f>();
    private final Map<Integer, Vector2f> oldLetterOffsets = new HashMap<Integer, Vector2f>();
    private int tickCounter;

    public TextEffectAnimation(String text) {
        ParsedDialog parsedDialog = ParsedDialog.parse(text);
        this.dialogLetterEffectList = TextEffect.apply(parsedDialog.effects());
    }

    public void tick() {
        ++this.tickCounter;
        this.oldLetterOffsets.clear();
        this.oldLetterOffsets.putAll(this.letterOffsets);
        for (DialogLetterEffect dialogLetterEffect : this.dialogLetterEffectList) {
            dialogLetterEffect.tick();
            if (dialogLetterEffect.getAnimation() == DialogAnimationType.SHAKE) {
                for (int j = dialogLetterEffect.getStartIndex(); j < dialogLetterEffect.getEndIndex(); ++j) {
                    RandomSource randomSource = RandomSource.create();
                    float offsetX = 0.0f;
                    float offsetY = 0.0f;
                    if (dialogLetterEffect.canApplyEffect()) {
                        offsetX = Mth.randomBetween((RandomSource)randomSource, (float)(-dialogLetterEffect.getForce()), (float)dialogLetterEffect.getForce());
                        offsetY = Mth.randomBetween((RandomSource)randomSource, (float)(-dialogLetterEffect.getForce()), (float)dialogLetterEffect.getForce());
                    } else if (this.letterOffsets.containsKey(j)) {
                        offsetX = this.letterOffsets.get((Object)Integer.valueOf((int)j)).x;
                        offsetY = this.letterOffsets.get((Object)Integer.valueOf((int)j)).y;
                    }
                    this.letterOffsets.put(j, new Vector2f(offsetX, offsetY));
                    this.oldLetterOffsets.put(j, new Vector2f(offsetX, offsetY));
                }
                if (!dialogLetterEffect.canApplyEffect()) continue;
                dialogLetterEffect.reset();
                continue;
            }
            if (dialogLetterEffect.getAnimation() != DialogAnimationType.WAVE) continue;
            float waveSpacing = 0.2f;
            double waveSpeed = (double)this.tickCounter / (double)dialogLetterEffect.getTotalTick();
            for (int j = dialogLetterEffect.getStartIndex(); j < dialogLetterEffect.getEndIndex(); ++j) {
                float offsetY = (float)(Math.sin(waveSpeed + (double)((float)j * waveSpacing)) * (double)dialogLetterEffect.getForce());
                this.letterOffsets.put(j, new Vector2f(0.0f, offsetY));
            }
        }
    }

    public Map<Integer, Vector2f> getOffsets(float partialTick) {
        HashMap<Integer, Vector2f> interpolated = new HashMap<Integer, Vector2f>();
        for (int j : this.letterOffsets.keySet()) {
            Vector2f oldOffset = this.oldLetterOffsets.getOrDefault(j, new Vector2f(0.0f, 0.0f));
            Vector2f newOffset = this.letterOffsets.get(j);
            float x = Mth.lerp((float)partialTick, (float)oldOffset.x, (float)newOffset.x);
            float y = Mth.lerp((float)partialTick, (float)oldOffset.y, (float)newOffset.y);
            interpolated.put(j, new Vector2f(x, y));
        }
        return interpolated;
    }
}

