/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.keyframe;

import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeGroup;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public abstract class AbstractKeyframeGroupsBase<T extends Keyframe, E extends KeyframeGroup<T>>
extends AbstractKeyframeController<T> {
    protected final List<E> keyframeGroups = new ArrayList();
    protected final AtomicInteger keyframeGroupsCounter = new AtomicInteger();

    public AbstractKeyframeGroupsBase(Environment environment, class_1657 player) {
        super(environment, player);
    }

    @Override
    public T getNextKeyframe(T toKeyframe) {
        for (int i = 0; i < this.keyframeGroups.size(); ++i) {
            KeyframeGroup group = (KeyframeGroup)this.keyframeGroups.get(i);
            List keyframes = group.getKeyframes();
            for (int j = 0; j < keyframes.size(); ++j) {
                if (((Keyframe)keyframes.get(j)).getId() != ((Keyframe)toKeyframe).getId()) continue;
                if (j + 1 < keyframes.size()) {
                    return (T)((Keyframe)keyframes.get(j + 1));
                }
                if (i + 1 >= this.keyframeGroups.size()) continue;
                return (T)((Keyframe)((KeyframeGroup)this.keyframeGroups.get(i + 1)).getKeyframes().getFirst());
            }
        }
        return toKeyframe;
    }

    @Override
    public T getPreviousKeyframe(T fromKeyframe) {
        for (int i = 0; i < this.keyframeGroups.size(); ++i) {
            KeyframeGroup group = (KeyframeGroup)this.keyframeGroups.get(i);
            List keyframes = group.getKeyframes();
            for (int j = 0; j < keyframes.size(); ++j) {
                if (((Keyframe)keyframes.get(j)).getId() != ((Keyframe)fromKeyframe).getId()) continue;
                if (j > 0) {
                    return (T)((Keyframe)keyframes.get(j - 1));
                }
                if (i <= 0) continue;
                List prevGroupKeyframes = ((KeyframeGroup)this.keyframeGroups.get(i - 1)).getKeyframes();
                return (T)((Keyframe)prevGroupKeyframes.getLast());
            }
        }
        return fromKeyframe;
    }

    @Override
    public T getKeyframeByEntity(class_1297 entity) {
        for (KeyframeGroup keyframeGroup : this.keyframeGroups) {
            for (Keyframe keyframe : keyframeGroup.getKeyframes()) {
                if (!Util.isSameEntity(entity, (class_1297)keyframe.getCamera())) continue;
                return (T)keyframe;
            }
        }
        return null;
    }

    @Override
    public void hideKeyframes(class_3222 player) {
        for (KeyframeGroup keyframeGroup : this.keyframeGroups) {
            keyframeGroup.hideKeyframes(player);
        }
        for (KeyframeTrigger keyframeTrigger : this.keyframeTriggers) {
            keyframeTrigger.hideKeyframe(player);
        }
    }

    @Override
    public void showKeyframes(class_3222 player) {
        for (KeyframeGroup keyframeGroup : this.keyframeGroups) {
            keyframeGroup.showKeyframes(player);
        }
        for (KeyframeTrigger keyframeTrigger : this.keyframeTriggers) {
            keyframeTrigger.showKeyframe(player);
        }
    }

    @Override
    public void removeKeyframe(T keyframe) {
        E keyframeGroup = this.getKeyframeGroupOfKeyframe(keyframe);
        ((Keyframe)keyframe).hideKeyframe(this.playerSession.getPlayer());
        ((KeyframeGroup)keyframeGroup).removeKeyframe(keyframe);
    }

    public E getKeyframeGroupOfKeyframe(T keyframe) {
        for (KeyframeGroup keyframeGroup : this.keyframeGroups) {
            for (Keyframe keyframeFromGroup : keyframeGroup.getKeyframes()) {
                if (((Keyframe)keyframe).getId() != keyframeFromGroup.getId()) continue;
                return (E)keyframeGroup;
            }
        }
        return null;
    }

    public List<E> getKeyframeGroups() {
        return this.keyframeGroups;
    }
}

