/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.managers.PlaybackManager;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.CommandUtil;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class PlaybackCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nc").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"playback").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"play").then(class_2170.method_9247((String)"animation").then(class_2170.method_9244((String)"animation_name", (ArgumentType)StringArgumentType.string()).suggests(PlaybackCommand::getAnimationSuggestion).executes(context -> PlaybackCommand.playAnimation((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"animation_name")))))).then(class_2170.method_9247((String)"subscene").then(class_2170.method_9244((String)"subscene_name", (ArgumentType)StringArgumentType.string()).suggests(PlaybackCommand::getSubscenesSuggestion).executes(context -> PlaybackCommand.playSubscene((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"subscene_name"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").then(class_2170.method_9247((String)"animation").then(class_2170.method_9244((String)"animation_name", (ArgumentType)StringArgumentType.string()).suggests(PlaybackCommand::getAnimationsPlaying).executes(context -> PlaybackCommand.stopAnimation((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"animation_name")))))).then(class_2170.method_9247((String)"subscene").then(class_2170.method_9244((String)"subscene_name", (ArgumentType)StringArgumentType.string()).suggests(PlaybackCommand::getSubscenesPlaying).executes(context -> PlaybackCommand.stopSubscene((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"subscene_name"))))))).then(class_2170.method_9247((String)"stop_all").executes(PlaybackCommand::stopAllPlayback))));
    }

    private static int playAnimation(CommandContext<class_2168> context, String animationName) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        Animation animation = playerSession.getScene().getAnimationByName(animationName);
        if (animation == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("animation.no_exists", animationName, playerSession.getScene().getName()));
            return 0;
        }
        Playback playback = new Playback(PlaybackManager.ID_INCREMENTER.incrementAndGet(), animation, (class_1937)((class_2168)context.getSource()).method_9225(), Environment.RECORDING, false);
        playback.start();
        ((class_2168)context.getSource()).method_9226(() -> Translation.message("playback.animation.play", animation.getName()), false);
        playerSession.getPlaybackManager().addPlayback(playback);
        return 1;
    }

    private static int playSubscene(CommandContext<class_2168> context, String subsceneName) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        Subscene subscene = playerSession.getScene().getSubsceneByName(subsceneName);
        if (subscene == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("subscene.no_exists", subsceneName, playerSession.getScene().getName()));
            return 0;
        }
        subscene.start((class_1937)((class_2168)context.getSource()).method_9225(), Environment.RECORDING, false);
        playerSession.getPlaybackManager().getPlaybacks().addAll(subscene.getPlaybacks());
        ((class_2168)context.getSource()).method_9226(() -> Translation.message("playback.subscene.play", subscene.getName()), false);
        return 1;
    }

    private static int stopAnimation(CommandContext<class_2168> context, String animationName) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        Animation animation = playerSession.getScene().getAnimationByName(animationName);
        if (animation == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("animation.no_exists", animationName, playerSession.getScene().getName()));
            return 0;
        }
        List<Playback> playbacks = playerSession.getPlaybackManager().getAnimationsByNamePlaying(animationName);
        if (playbacks.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("playback.animation.not_playing", animationName, playerSession.getScene().getName()));
            return 0;
        }
        for (Playback playback : playbacks) {
            playback.stop(true);
        }
        ((class_2168)context.getSource()).method_9226(() -> Translation.message("playback.animation.stop", animation.getName()), false);
        return 1;
    }

    private static int stopSubscene(CommandContext<class_2168> context, String subsceneName) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        Subscene subscene = playerSession.getScene().getSubsceneByName(subsceneName);
        if (subscene == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("subscene.no_exists", subsceneName, playerSession.getScene().getName()));
            return 0;
        }
        if (!subscene.isPlaying()) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("playback.subscene.not_playing", subsceneName, playerSession.getScene().getName()));
            return 0;
        }
        subscene.stop(true);
        ((class_2168)context.getSource()).method_9226(() -> Translation.message("playback.subscene.stop", subscene.getName()), false);
        return 1;
    }

    private static int stopAllPlayback(CommandContext<class_2168> context) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        PlaybackManager playbackManager = playerSession.getPlaybackManager();
        if (playbackManager.getPlaybacksPlaying().isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("playbacks.not_playing", new Object[0]));
            return 0;
        }
        playbackManager.stopAll();
        ((class_2168)context.getSource()).method_9226(() -> Translation.message("playback.stop_all", new Object[0]), false);
        return 1;
    }

    private static CompletableFuture<Suggestions> getAnimationSuggestion(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return builder.buildFuture();
        }
        return CommandUtil.getNamesNarrativeEntrySuggestion(builder, playerSession.getScene().getAnimations());
    }

    private static CompletableFuture<Suggestions> getSubscenesSuggestion(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return builder.buildFuture();
        }
        return CommandUtil.getNamesNarrativeEntrySuggestion(builder, playerSession.getScene().getSubscenes());
    }

    private static CompletableFuture<Suggestions> getAnimationsPlaying(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return builder.buildFuture();
        }
        ArrayList<Animation> animationPlaying = new ArrayList<Animation>();
        for (Playback playback : playerSession.getPlaybackManager().getAnimationsByNamePlaying()) {
            animationPlaying.add(playback.getAnimation());
        }
        return CommandUtil.getNamesNarrativeEntrySuggestion(builder, animationPlaying);
    }

    private static CompletableFuture<Suggestions> getSubscenesPlaying(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return builder.buildFuture();
        }
        ArrayList<Subscene> subscenePlaying = new ArrayList<Subscene>();
        for (Subscene subscene : playerSession.getScene().getSubscenes()) {
            if (!subscene.isPlaying()) continue;
            subscenePlaying.add(subscene);
        }
        return CommandUtil.getNamesNarrativeEntrySuggestion(builder, subscenePlaying);
    }
}

