/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.chapter.scene.data;

import fr.loudo.narrativecraft.managers.PlaybackManager;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.SceneData;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;

public class Subscene
extends SceneData {
    private transient List<Animation> animations = new ArrayList<Animation>();
    private transient List<Playback> playbacks = new ArrayList<Playback>();

    public Subscene(String name, String description, Scene scene) {
        super(name, description, scene);
    }

    public void start(class_1937 level, Environment environment, boolean looping) {
        this.playbacks = this.getPlaybacks();
        this.playbacks.clear();
        for (Animation animation : this.animations) {
            Playback playback = new Playback(PlaybackManager.ID_INCREMENTER.incrementAndGet(), animation, level, environment, looping);
            playback.start();
            this.playbacks.add(playback);
        }
    }

    public void start(class_1937 level, Environment environment, boolean looping, StoryHandler storyHandler) {
        this.playbacks = this.getPlaybacks();
        this.playbacks.clear();
        for (Animation animation : this.animations) {
            Playback playback = new Playback(PlaybackManager.ID_INCREMENTER.incrementAndGet(), animation, level, environment, looping);
            if (storyHandler != null) {
                playback.startFromStory(storyHandler);
            } else {
                playback.start();
            }
            this.playbacks.add(playback);
        }
    }

    public void stop(boolean killEntity) {
        for (Playback playback : this.playbacks) {
            playback.stop(killEntity);
        }
        this.getPlaybacks().clear();
    }

    public boolean isPlaying() {
        for (Playback playback : this.playbacks) {
            if (playback.isPlaying()) continue;
            return false;
        }
        return true;
    }

    public boolean hasEnded() {
        for (Playback playback : this.playbacks) {
            if (playback.hasEnded()) continue;
            return false;
        }
        return true;
    }

    public List<Playback> getPlaybacks() {
        if (this.playbacks == null) {
            this.playbacks = new ArrayList<Playback>();
        }
        return this.playbacks;
    }

    public List<Animation> getAnimations() {
        if (this.animations == null) {
            this.animations = new ArrayList<Animation>();
        }
        return this.animations;
    }

    public List<String> getAnimationsName() {
        return this.getAnimations().stream().map(NarrativeEntry::getName).toList();
    }
}

