/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.controllers.cameraAngle.CameraAngleController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.CameraAngle;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.keyframes.cameraAngle.CameraAngleKeyframe;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class CameraAngleInkAction
extends InkAction {
    private CameraAngle cameraAngle;
    private CameraAngleKeyframe keyframe;

    public CameraAngleInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() < 2) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Camera angle parent name missing"));
        }
        if (arguments.size() < 3) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Camera angle child name missing"));
        }
        String parentName = arguments.get(1);
        if (scene == null) {
            return InkActionResult.ignored();
        }
        this.cameraAngle = scene.getCameraAngleByName(parentName);
        if (this.cameraAngle == null) {
            return InkActionResult.error((class_2561)Translation.message("camera_angle.no_exists", parentName, scene.getName()));
        }
        String childName = arguments.get(2);
        this.keyframe = this.cameraAngle.getCameraAngleKeyframeByName(childName);
        if (this.keyframe == null) {
            return InkActionResult.error((class_2561)Translation.message("camera_angle.keyframe_no_exists", childName, parentName));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        AbstractController abstractController = playerSession.getController();
        if (abstractController instanceof CameraAngleController) {
            CameraAngleController cameraAngleController = (CameraAngleController)abstractController;
            playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof CameraAngleInkAction);
            if (!cameraAngleController.getCameraAngle().getName().equalsIgnoreCase(this.cameraAngle.getName())) {
                this.clear(playerSession);
            }
        } else if (!(playerSession.getController() instanceof CameraAngleController)) {
            this.clear(playerSession);
        }
        playerSession.setCurrentCamera(this.keyframe.getKeyframeLocation());
        class_310.method_1551().field_1690.field_1842 = true;
        playerSession.clearKilledCharacters();
        return InkActionResult.ok();
    }

    private void clear(PlayerSession playerSession) {
        ArrayList<CharacterRuntime> toRemove = new ArrayList<CharacterRuntime>();
        for (CharacterStoryData characterStoryData : this.cameraAngle.getCharacterStoryDataList()) {
            for (CharacterRuntime characterRuntime : playerSession.getCharacterRuntimes()) {
                if (!characterStoryData.getCharacterStory().getName().equalsIgnoreCase(characterRuntime.getCharacterStory().getName()) || characterStoryData.isTemplate() || characterRuntime.getEntity() == null) continue;
                NarrativeCraftMod.server.execute(() -> characterRuntime.getEntity().method_5650(class_1297.class_5529.field_26998));
                toRemove.add(characterRuntime);
            }
        }
        playerSession.getCharacterRuntimes().removeAll(toRemove);
        CameraAngleController controller = new CameraAngleController(Environment.PRODUCTION, (class_1657)playerSession.getPlayer(), this.cameraAngle);
        controller.startSession();
    }

    @Override
    public boolean needScene() {
        return true;
    }
}

