/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.text;

import fr.loudo.narrativecraft.narrative.dialog.DialogAnimationType;
import fr.loudo.narrativecraft.narrative.story.text.TextEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record ParsedDialog(String cleanedText, List<TextEffect> effects) {
    public static ParsedDialog parse(String dialogContent) {
        ArrayList<TextEffect> effects = new ArrayList<TextEffect>();
        StringBuilder cleanText = new StringBuilder();
        Pattern pattern = Pattern.compile("\\[(\\w+)((?:\\s+\\w+=[^\\]\\s]+)*?)\\](.*?)\\[/\\1\\]");
        Matcher matcher = pattern.matcher(dialogContent);
        int currentIndex = 0;
        while (matcher.find()) {
            DialogAnimationType type;
            cleanText.append(dialogContent, currentIndex, matcher.start());
            String effectName = matcher.group(1);
            String paramString = matcher.group(2).trim();
            String innerText = matcher.group(3);
            try {
                type = DialogAnimationType.valueOf(effectName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                cleanText.append(dialogContent, matcher.start(), matcher.end());
                currentIndex = matcher.end();
                continue;
            }
            int effectStart = cleanText.length();
            cleanText.append(innerText);
            int effectEnd = cleanText.length();
            HashMap<String, String> params = new HashMap<String, String>();
            if (!paramString.isEmpty()) {
                String[] parts;
                for (String part : parts = paramString.split("\\s+")) {
                    String[] kv = part.split("=");
                    if (kv.length != 2) continue;
                    params.put(kv[0], kv[1]);
                }
            }
            effects.add(new TextEffect(type, effectStart, effectEnd, params));
            currentIndex = matcher.end();
        }
        cleanText.append(dialogContent.substring(currentIndex));
        return new ParsedDialog(cleanText.toString(), effects);
    }
}

