/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.managers.CharacterManager;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import java.lang.reflect.Type;

public class CharacterStoryDataSerializer
implements JsonSerializer<CharacterStoryData>,
JsonDeserializer<CharacterStoryData> {
    private final String characterKey = "character_name";
    private final Scene scene;

    public CharacterStoryDataSerializer(Scene scene) {
        this.scene = scene;
    }

    public JsonElement serialize(CharacterStoryData characterStoryData, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new Gson().toJsonTree((Object)characterStoryData).getAsJsonObject();
        CharacterStory characterStory = characterStoryData.getCharacterStory();
        if (characterStory == null) {
            return obj;
        }
        obj.addProperty("character_name", characterStory.getName());
        return obj;
    }

    public CharacterStoryData deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        CharacterStoryData characterStoryData = (CharacterStoryData)new GsonBuilder().create().fromJson(json, CharacterStoryData.class);
        CharacterManager characterManager = NarrativeCraftMod.getInstance().getCharacterManager();
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("character_name")) {
            String characterName = jsonObject.get("character_name").getAsString();
            CharacterStory characterStory = characterManager.getCharacterByName(characterName);
            if (characterStory == null && this.scene != null && (characterStory = this.scene.getNpcByName(characterName)) == null) {
                return characterStoryData;
            }
            characterStoryData.setCharacterRuntime(new CharacterRuntime(characterStory, characterStoryData.getSkinName(), null));
        }
        return characterStoryData;
    }
}

