/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.managers;

import fr.loudo.narrativecraft.narrative.recording.Recording;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class RecordingManager {
    private final List<Recording> recordings = new ArrayList<Recording>();

    public void addRecording(Recording recording) {
        if (this.recordings.contains(recording)) {
            return;
        }
        this.recordings.add(recording);
    }

    public void removeRecording(Recording recording) {
        this.recordings.remove(recording);
    }

    public Recording getRecording(Entity entity) {
        for (Recording recording : this.recordings) {
            if (!recording.isSameEntity(entity)) continue;
            return recording;
        }
        return null;
    }

    public boolean isRecording(ServerPlayer player) {
        for (Recording recording : this.recordings) {
            if (!recording.isSameEntity((Entity)player) || !recording.isRecording()) continue;
            return true;
        }
        return false;
    }

    public List<Recording> getCurrentRecording() {
        return this.recordings.stream().filter(Recording::isRecording).toList();
    }

    public List<Recording> getRecordings() {
        return this.recordings;
    }
}

