/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.mainScreen.MainScreen;
import fr.loudo.narrativecraft.screens.options.StoryOptionsScreen;
import fr.loudo.narrativecraft.screens.storyManager.chapter.ChaptersScreen;
import fr.loudo.narrativecraft.screens.storyManager.character.CharactersScreen;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class OpenScreenCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nc").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"open").then(Commands.m_82127_((String)"story_manager").executes(OpenScreenCommand::openStoryManager))).then(Commands.m_82127_((String)"character_manager").executes(OpenScreenCommand::openCharacterManager))).then(Commands.m_82127_((String)"story_options").executes(OpenScreenCommand::openStoryOptions))).then(Commands.m_82127_((String)"main_screen").executes(OpenScreenCommand::openMainScreen))));
    }

    private static int openStoryOptions(CommandContext<CommandSourceStack> context) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).m_230896_());
        if (playerSession.getStoryHandler() != null) {
            return 0;
        }
        if (playerSession.getController() != null) {
            playerSession.getPlayer().m_213846_((Component)Translation.message("session.controller_set", new Object[0]));
            return 0;
        }
        if (NarrativeCraftMod.getInstance().getRecordingManager().isRecording(playerSession.getPlayer())) {
            playerSession.getPlayer().m_213846_((Component)Translation.message("record.cant_access", new Object[0]));
            return 0;
        }
        StoryOptionsScreen screen = new StoryOptionsScreen(playerSession);
        Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)screen));
        return 1;
    }

    private static int openStoryManager(CommandContext<CommandSourceStack> context) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).m_230896_());
        if (playerSession.getController() != null) {
            playerSession.getPlayer().m_213846_((Component)Translation.message("session.controller_set", new Object[0]));
            return 0;
        }
        if (playerSession.getStoryHandler() != null) {
            return 0;
        }
        if (NarrativeCraftMod.getInstance().getRecordingManager().isRecording(playerSession.getPlayer())) {
            playerSession.getPlayer().m_213846_((Component)Translation.message("record.cant_access", new Object[0]));
            return 0;
        }
        ChaptersScreen chaptersScreen = new ChaptersScreen();
        Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)chaptersScreen));
        return 1;
    }

    private static int openCharacterManager(CommandContext<CommandSourceStack> context) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).m_230896_());
        if (playerSession.getController() != null) {
            playerSession.getPlayer().m_213846_((Component)Translation.message("session.controller_set", new Object[0]));
            return 0;
        }
        if (NarrativeCraftMod.getInstance().getRecordingManager().isRecording(playerSession.getPlayer())) {
            playerSession.getPlayer().m_213846_((Component)Translation.message("record.cant_access", new Object[0]));
            return 0;
        }
        CharactersScreen screen = new CharactersScreen(null);
        Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)screen));
        return 1;
    }

    private static int openMainScreen(CommandContext<CommandSourceStack> context) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).m_230896_());
        if (playerSession.getStoryHandler() != null) {
            return 0;
        }
        if (playerSession.getController() != null) {
            playerSession.getPlayer().m_213846_((Component)Translation.message("session.controller_set", new Object[0]));
            return 0;
        }
        if (NarrativeCraftMod.getInstance().getRecordingManager().isRecording(playerSession.getPlayer())) {
            playerSession.getPlayer().m_213846_((Component)Translation.message("record.cant_access", new Object[0]));
            return 0;
        }
        MainScreen screen = new MainScreen(playerSession, false, false);
        Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)screen));
        return 1;
    }
}

