/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.managers;

import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class CharacterManager {
    private final List<CharacterStory> characterStories = new ArrayList<CharacterStory>();

    public void addCharacter(CharacterStory characterStory) {
        if (this.characterStories.contains(characterStory)) {
            return;
        }
        this.characterStories.add(characterStory);
    }

    public void removeCharacter(CharacterStory characterStory) {
        this.characterStories.remove(characterStory);
    }

    public CharacterStory getCharacterByName(String name) {
        for (CharacterStory characterStory : this.characterStories) {
            if (!characterStory.getName().equalsIgnoreCase(name)) continue;
            return characterStory;
        }
        return null;
    }

    public boolean characterExists(String name) {
        for (CharacterStory characterStory : this.characterStories) {
            if (!characterStory.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public List<CharacterStory> getCharacterStories() {
        return this.characterStories;
    }

    public List<EntityType<?>> getAvailableEntityTypes() {
        ArrayList finalList = new ArrayList();
        for (EntityType entityType : BuiltInRegistries.f_256780_.m_123024_().toList()) {
            String key = BuiltInRegistries.f_256780_.m_7981_((Object)entityType).m_135815_();
            if (entityType.m_20674_() == MobCategory.MISC && !key.equals("player") && !key.equals("villager")) continue;
            finalList.add(entityType);
        }
        return finalList;
    }
}

