/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.recording.Recording;
import fr.loudo.narrativecraft.narrative.recording.actions.ActionsData;
import fr.loudo.narrativecraft.narrative.recording.actions.HurtAction;
import fr.loudo.narrativecraft.narrative.recording.actions.SleepAction;
import fr.loudo.narrativecraft.narrative.recording.actions.SwingAction;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    public abstract void m_142687_(Entity.RemovalReason var1);

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="HEAD")})
    private void narrativecraft$onSwing(InteractionHand hand, CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntityMixin;
            Recording recording = NarrativeCraftMod.getInstance().getRecordingManager().getRecording((Entity)player);
            if (recording == null || !recording.isRecording()) {
                return;
            }
            SwingAction action = new SwingAction(recording.getTick(), hand);
            recording.getActionDataFromEntity((Entity)player).addAction(action);
        }
    }

    @Inject(method={"startSleeping"}, at={@At(value="HEAD")})
    private void narrativecraft$startSleep(BlockPos pos, CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntityMixin;
            Recording recording = NarrativeCraftMod.getInstance().getRecordingManager().getRecording((Entity)player);
            if (recording == null || !recording.isRecording()) {
                return;
            }
            SleepAction sleepAction = new SleepAction(recording.getTick(), pos);
            recording.getActionDataFromEntity((Entity)player).addAction(sleepAction);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void narrativecraft$hurtServer(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Recording recording = NarrativeCraftMod.getInstance().getRecordingManager().getRecording((Entity)player);
            if (recording == null || !recording.isRecording()) {
                return;
            }
            HurtAction hurtAction = new HurtAction(recording.getTick());
            LivingEntity livingEntity = (LivingEntity)this;
            ActionsData actionsData = recording.getActionDataFromEntity((Entity)livingEntity);
            if (actionsData == null) {
                return;
            }
            actionsData.addAction(hurtAction);
            recording.trackEntity((Entity)livingEntity, recording.getTick());
        }
    }
}

