/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.character;

import com.google.common.io.Files;
import com.mojang.blaze3d.platform.NativeImage;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterType;
import fr.loudo.narrativecraft.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class CharacterSkinController {
    private final Scene scene;
    private final CharacterRuntime characterRuntime;
    private final List<String> cachedSkins;
    private String skinName;
    private List<File> skins;
    private File currentSkin;

    public CharacterSkinController(CharacterRuntime characterRuntime, String skinName, Scene scene) {
        this.characterRuntime = characterRuntime;
        this.skinName = skinName;
        this.scene = scene;
        this.initSkins();
        this.cachedSkins = new ArrayList<String>();
    }

    private void initSkins() {
        if (this.characterRuntime.getCharacterStory() != null) {
            if (this.characterRuntime.getCharacterStory().getCharacterType() == CharacterType.MAIN) {
                this.skins = NarrativeCraftFile.getSkinFiles(this.characterRuntime.getCharacterStory());
            } else if (this.characterRuntime.getCharacterStory().getCharacterType() == CharacterType.NPC) {
                File mainSkin = NarrativeCraftFile.getSkinFile(this.characterRuntime.getCharacterStory(), this.scene);
                this.skins = new ArrayList<File>();
                if (mainSkin.exists()) {
                    this.skins.add(mainSkin);
                }
            }
        }
    }

    public void cacheSkins() {
        if (this.characterRuntime.getCharacterStory() == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        this.unCacheSkins();
        this.initSkins();
        for (File skin : this.skins) {
            String path = "character/" + Util.snakeCase(this.characterRuntime.getCharacterStory().getName()) + "/" + Util.snakeCase(skin.getName());
            minecraft.execute(() -> {
                try {
                    byte[] array = Files.toByteArray((File)skin);
                    NativeImage nativeImage = NativeImage.m_271751_((byte[])array);
                    DynamicTexture texture = new DynamicTexture(nativeImage);
                    minecraft.m_91097_().m_118495_(new ResourceLocation("narrativecraft", path), (AbstractTexture)texture);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            this.cachedSkins.add(path);
        }
        this.currentSkin = this.skinName == null || this.skinName.isEmpty() ? this.getMainSkinFile() : this.getSkinFile(this.skinName);
    }

    public void unCacheSkins() {
        Minecraft minecraft = Minecraft.m_91087_();
        for (String path : this.cachedSkins) {
            minecraft.execute(() -> minecraft.m_91097_().m_118513_(new ResourceLocation("narrativecraft", path)));
        }
        this.cachedSkins.clear();
    }

    public File getMainSkinFile() {
        for (File skin : this.skins) {
            if (!skin.getName().equals("main.png")) continue;
            return skin;
        }
        return null;
    }

    public File getSkinFile(String name) {
        for (File skin : this.skins) {
            if (!skin.getName().equals(name)) continue;
            return skin;
        }
        return null;
    }

    public List<File> getSkins() {
        return this.skins;
    }

    public File getCurrentSkin() {
        return this.currentSkin;
    }

    public List<String> getCachedSkins() {
        return this.cachedSkins;
    }

    public void setCurrentSkin(File skinFile) {
        this.currentSkin = skinFile;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }
}

