/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.keyframes;

import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;

public class KeyframeGroup<T extends Keyframe> {
    protected final List<T> keyframes = new ArrayList<T>();

    public List<T> getKeyframes() {
        return this.keyframes;
    }

    public boolean isLastKeyframe(T keyframe) {
        if (this.keyframes.isEmpty()) {
            return false;
        }
        return ((Keyframe)this.keyframes.get(this.keyframes.size() - 1)).getId() == ((Keyframe)keyframe).getId();
    }

    public void hideKeyframes(ServerPlayer player) {
        for (Keyframe keyframe : this.keyframes) {
            keyframe.hideKeyframe(player);
        }
    }

    public void showKeyframes(ServerPlayer player) {
        for (Keyframe keyframe : this.keyframes) {
            keyframe.showKeyframe(player);
        }
    }

    public void addKeyframe(T keyframe) {
        if (this.keyframes.contains(keyframe)) {
            return;
        }
        this.keyframes.add(keyframe);
    }

    public void removeKeyframe(T keyframe) {
        this.keyframes.remove(keyframe);
    }

    public T getKeyframeById(int id) {
        for (Keyframe keyframe : this.keyframes) {
            if (keyframe.id != id) continue;
            return (T)keyframe;
        }
        return null;
    }
}

