/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.BreakBlockAction;
import fr.loudo.narrativecraft.narrative.recording.actions.PlaceBlockAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ActionsData {
    private transient Entity entity;
    private final int entityId;
    private int entityIdRecording;
    private int spawnTick;
    private String nbtData;
    private final List<Location> locations = new ArrayList<Location>();
    private final List<Action> actions = new ArrayList<Action>();

    public ActionsData(Entity entity, int spawnTick) {
        this.entity = entity;
        if (!(entity instanceof ServerPlayer)) {
            this.nbtData = String.valueOf(this.serializeNBT());
        }
        this.entityId = BuiltInRegistries.f_256780_.m_7447_((Object)entity.m_6095_());
        this.spawnTick = spawnTick;
        this.entityIdRecording = -1;
    }

    private CompoundTag serializeNBT() {
        CompoundTag compoundTag = this.entity.m_20240_(new CompoundTag());
        compoundTag.m_128473_("UUID");
        compoundTag.m_128473_("Pos");
        compoundTag.m_128473_("Motion");
        return compoundTag;
    }

    public void addLocation() {
        Location currentLoc = new Location(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), this.entity.m_146909_(), this.entity.m_146908_(), this.entity.m_20096_());
        this.locations.add(currentLoc);
    }

    public void reset(Entity entity) {
        PlaybackData playbackData = new PlaybackData(this, null);
        playbackData.setEntity(entity);
        HashMap<BlockPos, Action> latestActions = new HashMap<BlockPos, Action>();
        for (Action action : this.actions) {
            BlockPos pos = this.getPosFromAction(action);
            if (pos == null) continue;
            latestActions.putIfAbsent(pos, action);
        }
        for (Map.Entry entry : latestActions.entrySet()) {
            Action action = (Action)entry.getValue();
            if (action instanceof PlaceBlockAction) {
                PlaceBlockAction place = (PlaceBlockAction)action;
                place.rewind(playbackData);
                continue;
            }
            if (!(action instanceof BreakBlockAction)) continue;
            BreakBlockAction breakBlockAction = (BreakBlockAction)action;
            breakBlockAction.rewind(playbackData);
        }
    }

    private BlockPos getPosFromAction(Action action) {
        if (action instanceof PlaceBlockAction) {
            PlaceBlockAction p = (PlaceBlockAction)action;
            return p.getBlockPos();
        }
        if (action instanceof BreakBlockAction) {
            BreakBlockAction b = (BreakBlockAction)action;
            return b.getBlockPos();
        }
        return null;
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(LivingEntity entity) {
        this.entity = entity;
    }

    public int getSpawnTick() {
        return this.spawnTick;
    }

    public void setSpawnTick(int spawnTick) {
        this.spawnTick = spawnTick;
    }

    public int getEntityIdRecording() {
        return this.entityIdRecording;
    }

    public void setEntityIdRecording(int entityIdRecording) {
        this.entityIdRecording = entityIdRecording;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getNbtData() {
        return this.nbtData;
    }
}

