/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionType;
import fr.loudo.narrativecraft.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class BreakBlockAction
extends Action {
    private int x;
    private int y;
    private int z;
    private String data;

    public BreakBlockAction(int tick, BlockPos blockPos, BlockState blockState) {
        super(tick, ActionType.BLOCK_BREAK);
        this.x = blockPos.m_123341_();
        this.y = blockPos.m_123342_();
        this.z = blockPos.m_123343_();
        this.data = NbtUtils.m_129202_((BlockState)blockState).toString();
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public String getData() {
        return this.data;
    }

    @Override
    public void execute(PlaybackData playbackData) {
        BlockPos blockPos = new BlockPos(this.x, this.y, this.z);
        BlockState blockState = Util.getBlockStateFromData(this.data, playbackData.getEntity().m_9236_().m_9598_());
        if (blockState != null) {
            if (blockState.m_60734_() instanceof BedBlock) {
                if (blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT) {
                    Direction direction = (Direction)blockState.m_61143_((Property)BedBlock.f_54117_);
                    blockPos = blockPos.m_121945_(direction);
                }
            } else if (blockState.m_60734_() instanceof DoorBlock && blockState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
                blockPos = blockPos.m_7495_();
            }
        }
        playbackData.getLevel().m_46961_(blockPos, false);
    }

    @Override
    public void rewind(PlaybackData playbackData) {
        if (!(playbackData.getEntity() instanceof LivingEntity)) {
            return;
        }
        BlockState blockState = Util.getBlockStateFromData(this.data, playbackData.getEntity().m_9236_().m_9598_());
        if (blockState == null) {
            return;
        }
        BlockPos blockPos = new BlockPos(this.x, this.y, this.z);
        Block block = blockState.m_60734_();
        if (block instanceof DoorBlock) {
            if (blockState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
                blockState = (BlockState)blockState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER);
                blockPos = blockPos.m_7495_();
            }
        } else if (blockState.m_60734_() instanceof BedBlock && blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
            Direction direction = (Direction)blockState.m_61143_((Property)BedBlock.f_54117_);
            blockState = (BlockState)blockState.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.FOOT);
            blockPos = blockPos.m_121945_(direction.m_122424_());
        }
        playbackData.getLevel().m_7731_(blockPos, blockState, 3);
        if (block instanceof BedBlock || block instanceof DoorBlock) {
            block.m_6402_(playbackData.getEntity().m_9236_(), blockPos, blockState, (LivingEntity)playbackData.getEntity(), blockState.m_60734_().m_5456_().m_7968_());
        }
    }
}

