/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.ActionsData;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionType;
import fr.loudo.narrativecraft.util.FakePlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DeathAction
extends Action {
    private final int entityRecordingId;

    public DeathAction(int tick, int entityRecordingId) {
        super(tick, ActionType.DEATH);
        this.entityRecordingId = entityRecordingId;
    }

    @Override
    public void execute(PlaybackData playbackData) {
        Entity entity;
        if (playbackData.getActionsData().getEntityIdRecording() == this.entityRecordingId && playbackData.getEntity() != null && (entity = playbackData.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof FakePlayer) {
                livingEntity.m_21153_(0.0f);
                livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)60);
            } else {
                livingEntity.m_7822_((byte)3);
            }
        }
    }

    @Override
    public void rewind(PlaybackData playbackData) {
        Playback playback = playbackData.getPlayback();
        if (playback.getEntityByRecordId(this.entityRecordingId).m_20148_().equals(playback.getMasterEntity().m_20148_())) {
            ActionsData actionsData = playback.getMasterEntityData();
            Location posToSpawn = actionsData.getLocations().get(playback.getTick() - 1);
            if (posToSpawn == null) {
                return;
            }
            playback.respawnMasterEntity(posToSpawn);
        } else {
            ActionsData actionsData = playback.getPlaybackDataByRecordId(this.entityRecordingId).getActionsData();
            Location posToSpawn = actionsData.getLocations().get(playback.getTick() - 1);
            if (posToSpawn == null) {
                return;
            }
            if (playbackData.getEntity() == null || !playbackData.getEntity().m_6084_()) {
                playbackData.spawnEntity(posToSpawn);
            }
        }
    }
}

