/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import com.mojang.datafixers.util.Pair;
import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionType;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemChangeAction
extends Action {
    private final int itemId;
    private final int oldItemId;
    private final String data;
    private final String oldData;
    private final String equipmentSlot;

    public ItemChangeAction(int waitTick, String equipmentSlot, ItemStack itemStack, ItemStack oldItemStack) {
        super(waitTick, ActionType.ITEM_CHANGE);
        this.itemId = BuiltInRegistries.f_257033_.m_7447_((Object)itemStack.m_41720_());
        this.oldItemId = BuiltInRegistries.f_257033_.m_7447_((Object)oldItemStack.m_41720_());
        this.equipmentSlot = equipmentSlot;
        this.data = this.getItemComponents(itemStack);
        this.oldData = this.getItemComponents(oldItemStack);
    }

    private String getItemComponents(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return null;
        }
        CompoundTag componentsTag = itemStack.m_41783_();
        if (componentsTag != null) {
            return itemStack.m_41783_().m_7916_();
        }
        return null;
    }

    @Override
    public void execute(PlaybackData playbackData) {
        Entity entity = playbackData.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.changeItem(livingEntity, this.itemId, this.data);
        }
    }

    @Override
    public void rewind(PlaybackData playbackData) {
        Entity entity = playbackData.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.changeItem(livingEntity, this.oldItemId, this.oldData);
        }
    }

    private void changeItem(LivingEntity entity, int itemId, String data) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7942_(itemId);
        ItemStack itemStack = new ItemStack((ItemLike)item);
        if (data != null) {
            CompoundTag tag = Util.tagFromIdAndComponents(item, data);
            itemStack.m_41751_(tag);
        }
        entity.m_20194_().m_6846_().m_11268_((Packet)new ClientboundSetEquipmentPacket(entity.m_19879_(), List.of(new Pair((Object)EquipmentSlot.valueOf((String)this.equipmentSlot), (Object)itemStack))));
        entity.m_8061_(EquipmentSlot.valueOf((String)this.equipmentSlot), itemStack);
    }
}

