/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class EditInfoScreen<T extends NarrativeEntry>
extends Screen {
    public final int WIDGET_WIDTH = 190;
    public final int EDIT_BOX_NAME_HEIGHT = 20;
    public final int EDIT_BOX_DESCRIPTION_HEIGHT = 90;
    public final int BUTTON_HEIGHT = 20;
    public final int GAP = 5;
    protected String name;
    protected String description;
    protected Button actionButton;
    protected Button backButton;
    protected ScreenUtils.LabelBox nameBox;
    protected ScreenUtils.MultilineLabelBox descriptionBox;
    protected StringWidget titleWidget;
    protected Screen lastScreen;
    protected T narrativeEntry;
    protected EditScreenAdapter<T> adapter;
    public Map<String, Object> extraFields = new HashMap<String, Object>();
    public List<String> descriptionPlaceholders = List.of("Once upon a time... In a wild... wild world...", "Until then is the reason this mod exists!", "Free palestine", "You should try narrative games", "Play Outer Wilds", "This screen was boring to code.", "I'm sure your creating a wonderful story!", "Your gender is valid!", "Easter egg message! No just kidding, not rare at all...", "Play Until Then", "Play Life Is Strange (NOT Double Exposure)", "Do their placeholders have a meaning anymore?", "Watch Frieren!", "Play Signalis", "The pain of your absence is sharp and haunting\nAnd i would give anything not to know it; anything but never knowing you at all, which would be worse", "The amazing digital circus is the best animation out there");

    public EditInfoScreen(Screen lastScreen, T narrativeEntry, EditScreenAdapter<T> adapter) {
        super((Component)Component.m_237113_((String)"Edit info"));
        this.name = narrativeEntry != null ? ((NarrativeEntry)narrativeEntry).getName() : "";
        this.description = narrativeEntry != null ? ((NarrativeEntry)narrativeEntry).getDescription() : "";
        this.lastScreen = lastScreen;
        this.narrativeEntry = narrativeEntry;
        this.adapter = adapter;
    }

    protected void m_7856_() {
        this.extraFields.clear();
        MutableComponent title = Component.m_237119_();
        int titleX = this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)title) / 2;
        Objects.requireNonNull(this.f_96547_);
        int labelHeight = 9 + 5;
        int centerX = this.f_96543_ / 2 - 95;
        int centerY = this.f_96544_ / 2 - (labelHeight + 25 + labelHeight + 90 + 40) / 2;
        if (this.adapter != null) {
            this.adapter.initExtraFields(this, this.narrativeEntry);
            for (Object object : this.extraFields.values()) {
                if (!(object instanceof AbstractWidget)) continue;
                AbstractWidget widget = (AbstractWidget)object;
                centerY -= widget.m_93694_() - 5;
            }
        }
        this.titleWidget = ScreenUtils.text((Component)title, this.f_96547_, titleX, centerY - labelHeight);
        this.m_142416_(this.titleWidget);
        MutableComponent nameLabel = Translation.message("global.name", new Object[0]).m_7220_((Component)Component.m_237113_((String)" *").m_130938_(style -> style.m_131140_(ChatFormatting.RED)));
        this.nameBox = new ScreenUtils.LabelBox((Component)nameLabel, this.f_96547_, 190, 20, centerX, centerY, ScreenUtils.Align.VERTICAL);
        this.nameBox.getEditBox().m_94144_(this.name);
        this.nameBox.getEditBox().m_94153_(text -> text.matches("[a-zA-Z0-9 _-]*"));
        this.m_142416_(this.nameBox.getStringWidget());
        this.m_142416_(this.nameBox.getEditBox());
        this.descriptionBox = new ScreenUtils.MultilineLabelBox((Component)Translation.message("global.description", new Object[0]), this.f_96547_, 190, 90, centerX, centerY += labelHeight + 20 + 5, (Component)Component.m_237113_((String)this.descriptionPlaceholders.get(new Random().nextInt(0, this.descriptionPlaceholders.size()))));
        this.descriptionBox.getMultiLineEditBox().m_240159_(this.description);
        this.m_142416_(this.descriptionBox.getStringWidget());
        this.m_142416_(this.descriptionBox.getMultiLineEditBox());
        this.adapter.renderExtraFields(this, this.narrativeEntry, centerX, centerY += labelHeight + 90 + 5);
        for (Object object : this.extraFields.values()) {
            if (!(object instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)object;
            centerY += widget.m_93694_() + 5;
        }
        MutableComponent mutableComponent = this.narrativeEntry == null ? Translation.message("global.add", new Object[0]) : Translation.message("global.update", new Object[0]);
        this.actionButton = Button.m_253074_((Component)mutableComponent, button -> {
            if (this.nameBox.getEditBox().m_94155_().isEmpty()) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("screen.edit_info.name_must", new Object[0]));
                return;
            }
            this.adapter.buildFromScreen(this.extraFields, this.f_96541_, this.narrativeEntry, this.nameBox.getEditBox().m_94155_(), this.descriptionBox.getMultiLineEditBox().m_239249_());
        }).m_252987_(centerX, centerY, 190, 20).m_253136_();
        this.m_142416_(this.actionButton);
        this.backButton = Button.m_253074_((Component)CommonComponents.f_130660_, button -> this.f_96541_.m_91152_(this.lastScreen)).m_252987_(centerX, centerY += 25, 190, 20).m_253136_();
        this.m_142416_(this.backButton);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public <T extends GuiEventListener & Renderable> T m_142416_(T widget) {
        return (T)super.m_142416_(widget);
    }

    public Font getFont() {
        return this.f_96541_.f_91062_;
    }
}

