/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.mainScreen;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.controllers.cutscene.CutscenePlayback;
import fr.loudo.narrativecraft.controllers.mainScreen.MainScreenController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.data.MainScreenData;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.narrative.story.StorySave;
import fr.loudo.narrativecraft.narrative.story.StoryValidation;
import fr.loudo.narrativecraft.narrative.story.inkAction.FadeInkAction;
import fr.loudo.narrativecraft.options.NarrativeWorldOption;
import fr.loudo.narrativecraft.screens.components.ChapterSelectorScreen;
import fr.loudo.narrativecraft.screens.components.CrashScreen;
import fr.loudo.narrativecraft.screens.components.FinishedStoryScreen;
import fr.loudo.narrativecraft.screens.components.NarrativeCraftLogoRenderer;
import fr.loudo.narrativecraft.screens.mainScreen.MainScreenOptionsScreen;
import fr.loudo.narrativecraft.util.ErrorLine;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;

public class MainScreen
extends Screen {
    public static final ResourceLocation BACKGROUND_IMAGE = new ResourceLocation("minecraft", "textures/narrativecraft_mainscreen/background.png");
    public static final ResourceLocation MUSIC = new ResourceLocation("minecraft", "narrativecraft_mainscreen.music");
    public static SimpleSoundInstance musicInstance = new SimpleSoundInstance(MUSIC, SoundSource.MASTER, 0.7f, 1.0f, SoundInstance.m_235150_(), true, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
    private final NarrativeCraftLogoRenderer narrativeCraftLogo = NarrativeCraftMod.getInstance().getNarrativeCraftLogoRenderer();
    private final PlayerSession playerSession;
    private final int buttonWidth = 100;
    private final int buttonHeight = 20;
    private final int initialX = 50;
    private final int gap = 5;
    private int initialY;
    private int showDevBtnCount;
    private Button devButton;
    private final boolean finishedStory;
    private final boolean pause;
    private boolean rendered;
    private int userFloodedKeyboard;

    public MainScreen(PlayerSession playerSession, boolean finishedStory, boolean pause) {
        super((Component)Component.m_237113_((String)"Main screen"));
        this.finishedStory = finishedStory;
        this.pause = pause;
        this.playerSession = playerSession;
        this.userFloodedKeyboard = 0;
    }

    private void playStory() {
        this.m_7379_();
        StoryHandler storyHandler = new StoryHandler(this.playerSession);
        this.f_96541_.m_91106_().m_120399_((SoundInstance)musicInstance);
        try {
            List<ErrorLine> errorLines = StoryValidation.validate();
            List<ErrorLine> warns = errorLines.stream().filter(ErrorLine::isWarn).toList();
            List<ErrorLine> errors = errorLines.stream().filter(errorLine -> !errorLine.isWarn()).toList();
            if (errors.isEmpty() && warns.isEmpty()) {
                NarrativeCraftMod.server.execute(storyHandler::start);
                return;
            }
            if (!warns.isEmpty()) {
                ConfirmScreen screen = new ConfirmScreen(t -> {
                    if (!t) {
                        this.f_96541_.m_91152_((Screen)this);
                        return;
                    }
                    this.f_96541_.m_91152_(null);
                    NarrativeCraftMod.server.execute(storyHandler::start);
                }, (Component)Component.m_237119_(), (Component)Translation.message("screen.main_screen.no_error_but_warns", new Object[0]));
                this.f_96541_.m_91152_((Screen)screen);
            } else {
                CrashScreen crashScreen = new CrashScreen(this.playerSession, Translation.message("validation.from_main_screen", new Object[0]).getString());
                this.f_96541_.m_91152_((Screen)crashScreen);
            }
            NarrativeCraftMod.LOGGER.error(" ");
            NarrativeCraftMod.LOGGER.error("Story can't start: ");
            for (ErrorLine errorLine2 : errorLines) {
                NarrativeCraftMod.LOGGER.error("{} {} {}", new Object[]{errorLine2.getFileName(), errorLine2.getLineText(), errorLine2.getMessage()});
            }
            NarrativeCraftMod.LOGGER.error(" ");
        }
        catch (Exception e) {
            CrashScreen crashScreen = new CrashScreen(this.playerSession, e.getMessage());
            this.f_96541_.m_91152_((Screen)crashScreen);
        }
    }

    public void m_7379_() {
        super.m_7379_();
        if (!this.pause) {
            this.f_96541_.m_91106_().m_120399_((SoundInstance)musicInstance);
            this.f_96541_.f_91066_.f_92062_ = false;
            if (this.playerSession.getController() != null) {
                NarrativeCraftMod.server.execute(() -> this.playerSession.getController().stopSession(false));
            }
        }
    }

    protected void m_7856_() {
        int totalButtons;
        boolean firstGame;
        boolean storyFinished = NarrativeCraftMod.getInstance().getNarrativeWorldOption().finishedStory;
        this.f_96541_.f_91066_.f_92062_ = true;
        this.showDevBtnCount = 0;
        StorySave save = null;
        try {
            save = NarrativeCraftFile.saveContent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = firstGame = save == null;
        if (!this.pause && this.playerSession.getController() == null) {
            try {
                MainScreenData mainScreenData = NarrativeCraftFile.getMainScreenBackground();
                MainScreenController mainScreenController = new MainScreenController(Environment.PRODUCTION, (Player)this.f_96541_.f_91074_, mainScreenData);
                NarrativeCraftMod.server.execute(mainScreenController::startSession);
            }
            catch (Exception mainScreenData) {
                // empty catch block
            }
        }
        if (!this.pause && !this.rendered) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)musicInstance);
            this.rendered = true;
        }
        int n = totalButtons = storyFinished ? 5 : 4;
        if (this.pause) {
            totalButtons = 5;
        }
        if (!NarrativeCraftFile.saveExists() && !this.pause) {
            totalButtons = 3;
        }
        int totalHeight = 20 * totalButtons + 5 * (totalButtons - 1);
        this.initialY = this.f_96544_ / 2 - totalHeight / 2;
        if (this.narrativeCraftLogo.logoExists()) {
            this.initialY += this.narrativeCraftLogo.getImageHeight() / 2 + 5;
        }
        int startY = this.initialY;
        MutableComponent playBtnComponent = firstGame && !this.pause ? Translation.message("screen.main_screen.play", new Object[0]) : Translation.message("screen.main_screen.continue", new Object[0]);
        boolean canPlay = !NarrativeCraftMod.getInstance().getChapterManager().getChapters().isEmpty();
        Button playButton = Button.m_253074_((Component)playBtnComponent, button -> {
            if (this.pause) {
                this.m_7379_();
            } else {
                this.playStory();
            }
        }).m_252987_(50, startY, 100, 20).m_253136_();
        playButton.f_93623_ = canPlay;
        if (!canPlay) {
            playButton.m_257544_(Tooltip.m_257550_((Component)Translation.message("screen.main_screen.cant_play_tooltip", new Object[0])));
        }
        this.m_142416_((GuiEventListener)playButton);
        if (!firstGame && !this.pause) {
            Button startNewGame = Button.m_253074_((Component)Translation.message("screen.main_screen.new_game", new Object[0]), button -> {
                ConfirmScreen confirmScreen = new ConfirmScreen(b -> {
                    if (b) {
                        NarrativeWorldOption option = NarrativeCraftMod.getInstance().getNarrativeWorldOption();
                        NarrativeCraftFile.removeSave();
                        option.finishedStory = false;
                        NarrativeCraftFile.updateWorldOptions(option);
                        this.playStory();
                    } else {
                        this.f_96541_.m_91152_((Screen)this);
                    }
                }, (Component)Component.m_237113_((String)""), (Component)Translation.message("screen.main_screen.new_game.confirm", new Object[0]), CommonComponents.f_130657_, CommonComponents.f_130656_);
                this.f_96541_.m_91152_((Screen)confirmScreen);
            }).m_252987_(50, startY += 25, 100, 20).m_253136_();
            startNewGame.f_93623_ = canPlay;
            if (!canPlay) {
                startNewGame.m_257544_(Tooltip.m_257550_((Component)Translation.message("screen.main_screen.cant_play_tooltip", new Object[0])));
            }
            this.m_142416_((GuiEventListener)startNewGame);
        }
        if (!this.pause && NarrativeCraftMod.getInstance().getNarrativeWorldOption().finishedStory) {
            Button selectSceneButton = Button.m_253074_((Component)Translation.message("screen.main_screen.select_screen", new Object[0]), button -> {
                this.f_96541_.m_91106_().m_120399_((SoundInstance)musicInstance);
                ChapterSelectorScreen screen = new ChapterSelectorScreen(this.playerSession, this);
                this.f_96541_.m_91152_((Screen)screen);
            }).m_252987_(50, startY += 25, 100, 20).m_253136_();
            this.m_142416_((GuiEventListener)selectSceneButton);
        }
        if (this.pause) {
            Button loadLastSaveButton = Button.m_253074_((Component)(this.playerSession.getStoryHandler().isDebugMode() ? Translation.message("screen.main_screen.pause.restart_scene", new Object[0]) : Translation.message("screen.main_screen.pause.load_last_save", new Object[0])), button -> {
                StoryHandler storyHandler;
                this.f_96541_.m_91152_(null);
                if (this.playerSession.getStoryHandler().isDebugMode()) {
                    storyHandler = new StoryHandler(this.playerSession.getChapter(), this.playerSession.getScene(), this.playerSession);
                    storyHandler.setDebugMode(this.playerSession.getStoryHandler().isDebugMode());
                } else {
                    storyHandler = new StoryHandler(this.playerSession);
                }
                try {
                    List<ErrorLine> results = StoryValidation.validate();
                    List<ErrorLine> errorLines = results.stream().filter(errorLine -> !errorLine.isWarn()).toList();
                    if (errorLines.isEmpty()) {
                        NarrativeCraftMod.server.execute(() -> {
                            this.playerSession.getStoryHandler().stop();
                            storyHandler.start();
                        });
                    } else {
                        NarrativeCraftMod.server.execute(() -> this.playerSession.getStoryHandler().stop());
                        for (ErrorLine errorLine2 : results) {
                            this.f_96541_.f_91074_.m_5661_(errorLine2.toMessage(), false);
                        }
                    }
                }
                catch (Exception e) {
                    Util.sendCrashMessage((Player)this.f_96541_.f_91074_, e);
                }
            }).m_252987_(50, startY += 25, 100, 20).m_253136_();
            this.m_142416_((GuiEventListener)loadLastSaveButton);
            AbstractController controller = this.playerSession.getController();
            Button skipCutsceneButton = Button.m_253074_((Component)Translation.message("screen.main_screen.pause.skip_cutscene", new Object[0]), button -> {
                CutsceneController cutsceneController;
                CutscenePlayback cutscenePlayback;
                this.f_96541_.m_91152_(null);
                if (controller instanceof CutsceneController && (cutscenePlayback = (cutsceneController = (CutsceneController)controller).getCutscenePlayback()) != null) {
                    this.playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof FadeInkAction);
                    NarrativeCraftMod.server.execute(cutsceneController::skip);
                    cutscenePlayback.stop();
                    CutsceneKeyframe keyframe = cutsceneController.getLastKeyframeLastGroup();
                    if (keyframe == null) {
                        return;
                    }
                    this.playerSession.setCurrentCamera(keyframe.getKeyframeLocation());
                }
            }).m_252987_(50, startY += 25, 100, 20).m_253136_();
            skipCutsceneButton.f_93623_ = controller instanceof CutsceneController && controller != null;
            this.m_142416_((GuiEventListener)skipCutsceneButton);
        }
        Button optionsButton = Button.m_253074_((Component)Translation.message("screen.main_screen.options", new Object[0]), button -> {
            this.f_96541_.m_91106_().m_120399_((SoundInstance)musicInstance);
            MainScreenOptionsScreen screen = new MainScreenOptionsScreen(this.playerSession, new MainScreen(this.playerSession, false, this.pause));
            this.f_96541_.m_91152_((Screen)screen);
        }).m_252987_(50, startY += 25, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)optionsButton);
        if (this.pause) {
            quitButton = Button.m_253074_((Component)Translation.message("screen.main_screen.pause.leave", new Object[0]), button -> {
                boolean debugMod = this.playerSession.getStoryHandler().isDebugMode();
                NarrativeCraftMod.server.execute(() -> {
                    this.playerSession.getStoryHandler().stop();
                    if (NarrativeCraftMod.getInstance().getNarrativeWorldOption().showMainScreen && !debugMod) {
                        MainScreen mainScreen = new MainScreen(this.playerSession, false, false);
                        this.f_96541_.execute(() -> this.f_96541_.m_91152_((Screen)mainScreen));
                    } else {
                        this.f_96541_.execute(() -> this.f_96541_.m_91152_(null));
                    }
                });
            }).m_252987_(50, startY += 25, 100, 20).m_253136_();
            this.m_142416_((GuiEventListener)quitButton);
        } else {
            quitButton = Button.m_253074_((Component)Translation.message("screen.main_screen.quit", new Object[0]), button -> Util.disconnectPlayer()).m_252987_(50, startY += 25, 100, 20).m_253136_();
            this.m_142416_((GuiEventListener)quitButton);
        }
        this.devButton = Button.m_253074_((Component)Component.m_237113_((String)"Dev Environment"), button -> {
            this.f_96541_.f_91074_.m_5661_((Component)Translation.message("global.dev_env", new Object[0]), false);
            this.m_7379_();
        }).m_252987_(this.f_96543_ - 100 - 10, 20, 100, 20).m_253136_();
        if (this.finishedStory) {
            FinishedStoryScreen screen = new FinishedStoryScreen(this.playerSession);
            this.f_96541_.m_91152_((Screen)screen);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        if (this.narrativeCraftLogo.logoExists()) {
            this.narrativeCraftLogo.render(guiGraphics, 50, this.initialY - this.narrativeCraftLogo.getImageHeight() - 5 - 5);
        }
        if (NarrativeCraftMod.getInstance().getChapterManager().getChapters().isEmpty() || this.userFloodedKeyboard > 20) {
            guiGraphics.m_280488_(this.f_96541_.f_91062_, Translation.message("screen.main_screen.dev_tip", new Object[0]).getString(), guiGraphics.m_280182_() / 2 - this.f_96541_.f_91062_.m_92852_((FormattedText)Translation.message("screen.main_screen.dev_tip", new Object[0])) / 2, 20, FastColor.ABGR32.m_266248_((int)1, (int)1, (int)1, (int)1));
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        if (this.pause) {
            super.m_280273_(guiGraphics);
            return;
        }
        if (this.playerSession.getController() != null) {
            return;
        }
        if (Util.resourceExists(BACKGROUND_IMAGE)) {
            guiGraphics.m_280163_(BACKGROUND_IMAGE, 0, 0, 0.0f, 0.0f, guiGraphics.m_280182_(), guiGraphics.m_280206_(), guiGraphics.m_280182_(), guiGraphics.m_280206_());
        } else {
            guiGraphics.m_280509_(0, 0, guiGraphics.m_280182_(), guiGraphics.m_280206_(), -16777216);
        }
    }

    public boolean m_7043_() {
        return this.pause;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.pause) {
            ++this.userFloodedKeyboard;
        }
        if (keyCode == 341 && !this.pause) {
            ++this.showDevBtnCount;
            if (this.showDevBtnCount == 5) {
                this.m_142416_((GuiEventListener)this.devButton);
            }
        }
        if (keyCode == 256 && !this.pause) {
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

