/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.options;

import com.mojang.authlib.GameProfile;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogEntityBobbing;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.FakePlayer;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;

public class DialogCustomOptionsScreen
extends Screen {
    private final Screen lastScreen;
    private final PlayerSession playerSession;
    private final DialogData dialogData = new DialogData(DialogData.globalDialogData);
    private FakePlayer fakePlayer;
    private Vec3 lastPos;
    private float lastXRot;
    private float lastYRot;
    private ScreenUtils.LabelBox paddingXBox;
    private ScreenUtils.LabelBox paddingYBox;
    private ScreenUtils.LabelBox scaleBox;
    private ScreenUtils.LabelBox letterSpacingBox;
    private ScreenUtils.LabelBox gapBox;
    private ScreenUtils.LabelBox widthBox;
    private ScreenUtils.LabelBox bcColorBox;
    private ScreenUtils.LabelBox textColorBox;
    private ScreenUtils.LabelBox bobbingSpeed;
    private ScreenUtils.LabelBox bobbingStrength;
    private StringWidget errorWidget;

    public DialogCustomOptionsScreen(Screen lastScreen, PlayerSession playerSession) {
        super((Component)Component.m_237113_((String)"Character Custom Dialog Screen"));
        this.lastScreen = lastScreen;
        this.playerSession = playerSession;
    }

    public void m_7379_() {
        LocalPlayer player = this.f_96541_.f_91074_;
        player.m_146884_(this.lastPos);
        player.m_146926_(this.lastXRot);
        player.m_146922_(this.lastYRot);
        player.m_5616_(this.lastYRot);
        NarrativeCraftMod.server.execute(() -> {
            this.fakePlayer.m_142687_(Entity.RemovalReason.KILLED);
            this.playerSession.getPlayer().f_8906_.m_9829_((Packet)new ClientboundPlayerInfoRemovePacket(List.of(this.fakePlayer.m_20148_())));
            this.playerSession.getPlayer().f_8906_.m_9829_((Packet)new ClientboundRemoveEntitiesPacket(new int[]{this.fakePlayer.m_19879_()}));
            this.playerSession.getPlayer().m_143403_(GameType.CREATIVE);
        });
        this.playerSession.setDialogRenderer(null);
        this.f_96541_.m_91152_(this.lastScreen);
        this.f_96541_.f_91066_.f_92062_ = false;
    }

    protected void m_7856_() {
        this.f_96541_.f_91066_.f_92062_ = true;
        if (this.fakePlayer == null) {
            Vec3 localPos;
            LocalPlayer player = this.f_96541_.f_91074_;
            this.lastPos = localPos = player.m_20182_();
            this.lastXRot = player.m_146909_();
            this.lastYRot = player.m_146908_();
            this.f_96541_.f_91066_.m_92157_(CameraType.FIRST_PERSON);
            player.m_20334_(0.0, 0.0, 0.0);
            player.m_6034_(localPos.f_82479_, localPos.f_82480_ + (double)player.m_20192_() + 5.0, localPos.f_82481_);
            player.m_146926_(0.0f);
            player.m_146922_(0.0f);
            player.m_5616_(0.0f);
            NarrativeCraftMod.server.execute(() -> {
                this.fakePlayer = new FakePlayer((ServerLevel)this.playerSession.getPlayer().m_9236_(), new GameProfile(UUID.randomUUID(), ""));
                this.fakePlayer.m_146926_(0.0f);
                this.fakePlayer.m_5616_(180.0f);
                this.fakePlayer.m_146922_(180.0f);
                this.fakePlayer.m_6034_(localPos.f_82479_, localPos.f_82480_ + (double)player.m_20192_() + 4.2, localPos.f_82481_ + 2.0);
                this.playerSession.getPlayer().f_8906_.m_9829_((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)this.fakePlayer));
                this.playerSession.getPlayer().m_9236_().m_7967_((Entity)this.fakePlayer);
                this.playerSession.getPlayer().m_143403_(GameType.SPECTATOR);
                DialogRenderer3D dialog = new DialogRenderer3D("Lorem ipsum dolor sit amet consectetur adipiscing elit\n", "", this.dialogData, new CharacterRuntime(null, null, (LivingEntity)this.fakePlayer, this.playerSession.getScene()));
                dialog.setDialogEntityBobbing(new DialogEntityBobbing(dialog, this.dialogData.getNoiseShakeSpeed(), this.dialogData.getNoiseShakeStrength()));
                dialog.setNoSkip(true);
                dialog.start();
                this.playerSession.setDialogRenderer(dialog);
            });
        }
        int gap = 5;
        int labelHeight = 20;
        int labelWidth = 50;
        int startX = this.f_96543_ - labelWidth - 120;
        this.errorWidget = ScreenUtils.text((Component)Component.m_237113_((String)""), this.f_96541_.f_91062_, this.f_96543_ / 2, 10);
        this.m_142416_((GuiEventListener)this.errorWidget);
        int currentY = this.f_96544_ / 2 - (labelHeight + gap) * 12 / 2;
        this.paddingXBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Padding X"), this.f_96541_.f_91062_, labelWidth, labelHeight, startX, currentY, ScreenUtils.Align.HORIZONTAL);
        this.paddingXBox.getEditBox().m_94144_(String.valueOf(this.dialogData.getPaddingX()));
        this.m_142416_((GuiEventListener)this.paddingXBox.getStringWidget());
        this.m_142416_((GuiEventListener)this.paddingXBox.getEditBox());
        this.paddingYBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Padding Y"), this.f_96541_.f_91062_, labelWidth, labelHeight, startX, currentY += this.paddingXBox.getEditBox().m_93694_() + gap, ScreenUtils.Align.HORIZONTAL);
        this.paddingYBox.getEditBox().m_94144_(String.valueOf(this.dialogData.getPaddingY()));
        this.m_142416_((GuiEventListener)this.paddingYBox.getStringWidget());
        this.m_142416_((GuiEventListener)this.paddingYBox.getEditBox());
        this.scaleBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Scale"), this.f_96541_.f_91062_, labelWidth, labelHeight, startX, currentY += this.paddingYBox.getEditBox().m_93694_() + gap, ScreenUtils.Align.HORIZONTAL);
        this.scaleBox.getEditBox().m_94144_(String.valueOf(this.dialogData.getScale()));
        this.m_142416_((GuiEventListener)this.scaleBox.getStringWidget());
        this.m_142416_((GuiEventListener)this.scaleBox.getEditBox());
        this.letterSpacingBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Letter Spacing"), this.f_96541_.f_91062_, labelWidth, labelHeight, startX, currentY += this.scaleBox.getEditBox().m_93694_() + gap, ScreenUtils.Align.HORIZONTAL);
        this.letterSpacingBox.getEditBox().m_94144_(String.valueOf(this.dialogData.getLetterSpacing()));
        this.m_142416_((GuiEventListener)this.letterSpacingBox.getStringWidget());
        this.m_142416_((GuiEventListener)this.letterSpacingBox.getEditBox());
        this.gapBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Gap"), this.f_96541_.f_91062_, labelWidth, labelHeight, startX, currentY += this.letterSpacingBox.getEditBox().m_93694_() + gap, ScreenUtils.Align.HORIZONTAL);
        this.gapBox.getEditBox().m_94144_(String.valueOf(this.dialogData.getGap()));
        this.m_142416_((GuiEventListener)this.gapBox.getStringWidget());
        this.m_142416_((GuiEventListener)this.gapBox.getEditBox());
        this.widthBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Width"), this.f_96541_.f_91062_, labelWidth, labelHeight, startX, currentY += this.gapBox.getEditBox().m_93694_() + gap, ScreenUtils.Align.HORIZONTAL);
        this.widthBox.getEditBox().m_94144_(String.valueOf(this.dialogData.getWidth()));
        this.m_142416_((GuiEventListener)this.widthBox.getStringWidget());
        this.m_142416_((GuiEventListener)this.widthBox.getEditBox());
        this.bcColorBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Background Color"), this.f_96541_.f_91062_, labelWidth, labelHeight, startX, currentY += this.widthBox.getEditBox().m_93694_() + gap, ScreenUtils.Align.HORIZONTAL);
        this.bcColorBox.getEditBox().m_94144_(Integer.toHexString(FastColor.ABGR32.m_266498_((int)0, (int)this.dialogData.getBackgroundColor())));
        this.m_142416_((GuiEventListener)this.bcColorBox.getStringWidget());
        this.m_142416_((GuiEventListener)this.bcColorBox.getEditBox());
        this.textColorBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Text Color"), this.f_96541_.f_91062_, labelWidth, labelHeight, startX, currentY += this.bcColorBox.getEditBox().m_93694_() + gap, ScreenUtils.Align.HORIZONTAL);
        this.textColorBox.getEditBox().m_94144_(Integer.toHexString(FastColor.ABGR32.m_266498_((int)0, (int)this.dialogData.getTextColor())));
        this.m_142416_((GuiEventListener)this.textColorBox.getStringWidget());
        this.m_142416_((GuiEventListener)this.textColorBox.getEditBox());
        this.bobbingSpeed = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Bobbing Speed"), this.f_96541_.f_91062_, labelWidth, labelHeight, startX, currentY += this.textColorBox.getEditBox().m_93694_() + gap, ScreenUtils.Align.HORIZONTAL);
        this.bobbingSpeed.getEditBox().m_94144_(String.valueOf(this.dialogData.getNoiseShakeSpeed()));
        this.m_142416_((GuiEventListener)this.bobbingSpeed.getStringWidget());
        this.m_142416_((GuiEventListener)this.bobbingSpeed.getEditBox());
        this.bobbingStrength = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Bobbing Strength"), this.f_96541_.f_91062_, labelWidth, labelHeight, startX, currentY += this.bobbingSpeed.getEditBox().m_93694_() + gap, ScreenUtils.Align.HORIZONTAL);
        this.bobbingStrength.getEditBox().m_94144_(String.valueOf(this.dialogData.getNoiseShakeStrength()));
        this.m_142416_((GuiEventListener)this.bobbingStrength.getStringWidget());
        this.m_142416_((GuiEventListener)this.bobbingStrength.getEditBox());
        Button updateButton = Button.m_253074_((Component)Translation.message("global.update", new Object[0]), button -> this.updateValues()).m_252794_(startX, currentY += this.bobbingStrength.getEditBox().m_93694_() + gap).m_252780_(70).m_253136_();
        this.m_142416_((GuiEventListener)updateButton);
        Button doneButton = Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            try {
                this.updateValues();
                NarrativeCraftFile.updateGlobalDialogValues(this.dialogData);
                DialogData.globalDialogData = this.dialogData;
            }
            catch (IOException e) {
                Util.sendCrashMessage((Player)this.f_96541_.f_91074_, e);
            }
            this.m_7379_();
        }).m_252794_(updateButton.m_252754_() + updateButton.m_5711_() + 5, currentY).m_252780_(70).m_253136_();
        this.m_142416_((GuiEventListener)doneButton);
        Button closeButton = Button.m_253074_((Component)Translation.message("global.close", new Object[0]), button -> {
            this.updateValues();
            this.m_7379_();
        }).m_252794_(startX, currentY += updateButton.m_93694_() + gap).m_252780_(70).m_253136_();
        this.m_142416_((GuiEventListener)closeButton);
    }

    private void updateValues() {
        try {
            this.dialogData.setPaddingX(Float.parseFloat(this.paddingXBox.getEditBox().m_94155_()));
            this.dialogData.setPaddingY(Float.parseFloat(this.paddingYBox.getEditBox().m_94155_()));
            this.dialogData.setScale(Float.parseFloat(this.scaleBox.getEditBox().m_94155_()));
            this.dialogData.setLetterSpacing(Float.parseFloat(this.letterSpacingBox.getEditBox().m_94155_()));
            this.dialogData.setGap(Float.parseFloat(this.gapBox.getEditBox().m_94155_()));
            this.dialogData.setWidth(Float.parseFloat(this.widthBox.getEditBox().m_94155_()));
            int backgroundColor = Integer.parseInt(this.bcColorBox.getEditBox().m_94155_(), 16);
            this.dialogData.setBackgroundColor(FastColor.ABGR32.m_266498_((int)255, (int)backgroundColor));
            this.dialogData.setTextColor(Integer.parseInt(this.textColorBox.getEditBox().m_94155_(), 16));
            this.dialogData.setNoiseShakeSpeed(Float.parseFloat(this.bobbingSpeed.getEditBox().m_94155_()));
            this.dialogData.setNoiseShakeStrength(Float.parseFloat(this.bobbingStrength.getEditBox().m_94155_()));
            DialogRenderer3D dialog = (DialogRenderer3D)this.playerSession.getDialogRenderer();
            dialog.setText(dialog.getText());
            dialog.setPaddingX(this.dialogData.getPaddingX());
            dialog.setPaddingY(this.dialogData.getPaddingY());
            dialog.setScale(this.dialogData.getScale());
            dialog.setLetterSpacing(this.dialogData.getLetterSpacing());
            dialog.setGap(this.dialogData.getGap());
            dialog.setWidth(this.dialogData.getWidth());
            dialog.setBackgroundColor(this.dialogData.getBackgroundColor());
            dialog.setTextColor(this.dialogData.getTextColor());
            dialog.getDialogEntityBobbing().setNoiseShakeSpeed(this.dialogData.getNoiseShakeSpeed());
            dialog.getDialogEntityBobbing().setNoiseShakeStrength(this.dialogData.getNoiseShakeStrength());
            dialog.update();
            this.errorWidget.m_93666_((Component)Component.m_237119_());
        }
        catch (NumberFormatException e) {
            MutableComponent message = Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.RED);
            this.errorWidget.m_93666_((Component)message);
            this.errorWidget.m_264152_(this.f_96543_ / 2 - this.f_96541_.f_91062_.m_92852_((FormattedText)message) / 2, 10);
            this.errorWidget.m_93674_(this.f_96541_.f_91062_.m_92852_((FormattedText)message));
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }
}

