/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.chapter;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.ChapterManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.chapter.EditScreenChapterAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesScreen;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ChaptersScreen
extends StoryElementScreen {
    public ChaptersScreen() {
        super((Component)Translation.message("screen.story_manager.chapter_list", new Object[0]));
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<Chapter> screen = new EditInfoScreen<Chapter>((Screen)this, null, new EditScreenChapterAdapter());
            this.f_96541_.m_91152_(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, p_345997_ -> this.m_7379_()).m_252780_(200).m_253136_());
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.m_137581_().m_137644_(NarrativeCraftFile.chaptersDirectory);
    }

    @Override
    protected void addContents() {
        ChapterManager chapterManager = NarrativeCraftMod.getInstance().getChapterManager();
        List<StoryElementList.StoryEntryData> entries = chapterManager.getChapters().stream().map(chapter -> {
            Object label = String.valueOf(chapter.getIndex());
            if (!chapter.getName().isEmpty()) {
                label = (String)label + " - " + chapter.getName();
            }
            Button button = Button.m_253074_((Component)Component.m_237113_((String)label), b -> this.f_96541_.m_91152_((Screen)new ScenesScreen((Chapter)chapter))).m_253136_();
            return new StoryElementList.StoryEntryData(button, () -> this.f_96541_.m_91152_(new EditInfoScreen<Chapter>((Screen)this, (Chapter)chapter, new EditScreenChapterAdapter())), () -> {
                try {
                    chapterManager.removeChapter((Chapter)chapter);
                    NarrativeCraftFile.deleteChapterDirectory(chapter);
                    this.f_96541_.m_91152_((Screen)new ChaptersScreen());
                }
                catch (Exception e) {
                    chapterManager.addChapter((Chapter)chapter);
                    Util.sendCrashMessage((Player)this.f_96541_.f_91074_, e);
                }
            });
        }).toList();
        this.storyElementList = new StoryElementList(this.f_96541_, (Screen)this, entries, true);
    }
}

