/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.cutscene;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.cutscene.CutscenesScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EditScreenCutsceneAdapter
implements EditScreenAdapter<Cutscene> {
    private final Scene scene;

    public EditScreenCutsceneAdapter(Scene scene) {
        this.scene = scene;
    }

    @Override
    public void initExtraFields(EditInfoScreen<Cutscene> screen, Cutscene entry) {
    }

    @Override
    public void renderExtraFields(EditInfoScreen<Cutscene> screen, Cutscene entry, int x, int y) {
    }

    @Override
    public void buildFromScreen(Map<String, Object> extraFields, Minecraft minecraft, @Nullable Cutscene existing, String name, String description) {
        if (existing == null) {
            if (this.scene.cutsceneExists(name)) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("cutscene.already_exists", name, this.scene.getName()));
                return;
            }
            Cutscene cutscene = new Cutscene(name, description, this.scene);
            try {
                this.scene.addCutscene(cutscene);
                NarrativeCraftFile.updateCutsceneFile(this.scene);
                minecraft.m_91152_((Screen)new CutscenesScreen(this.scene));
            }
            catch (Exception e) {
                this.scene.removeCutscene(cutscene);
                Util.sendCrashMessage((Player)minecraft.f_91074_, e);
                minecraft.m_91152_(null);
            }
        } else {
            Cutscene oldCutscene = new Cutscene(existing.getName(), existing.getDescription(), this.scene);
            try {
                existing.setName(name);
                existing.setDescription(description);
                NarrativeCraftFile.updateCutsceneFile(this.scene);
                minecraft.m_91152_((Screen)new CutscenesScreen(this.scene));
            }
            catch (Exception e) {
                existing.setName(oldCutscene.getName());
                existing.setDescription(oldCutscene.getDescription());
                Util.sendCrashMessage((Player)minecraft.f_91074_, e);
                minecraft.m_91152_(null);
            }
        }
    }
}

