/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.util;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandUtil {
    public static PlayerSession getSession(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)player);
        if (!playerSession.isSessionSet()) {
            if (Util.isSamePlayer(((CommandSourceStack)context.getSource()).m_230896_(), player)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Translation.message("session.not_set", new Object[0]));
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Translation.message("session.player_not_set", player.m_7755_()));
            }
            return null;
        }
        return playerSession;
    }

    public static CompletableFuture<Suggestions> getNamesNarrativeEntrySuggestion(SuggestionsBuilder builder, List<? extends NarrativeEntry> narrativeEntries) {
        for (NarrativeEntry narrativeEntry : narrativeEntries) {
            if (narrativeEntry.getName().split(" ").length > 1) {
                builder.suggest("\"" + narrativeEntry.getName() + "\"");
                continue;
            }
            builder.suggest(narrativeEntry.getName());
        }
        return builder.buildFuture();
    }
}

