/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.util;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;

public class ScreenUtils {
    public static StringWidget text(Component text, Font font, int x, int y) {
        return new StringWidget(x, y, font.m_92724_(text.m_7532_()), 9, text, font);
    }

    public static StringWidget text(Component text, Font font, int x, int y, int color) {
        StringWidget stringWidget = new StringWidget(x, y, font.m_92724_(text.m_7532_()), 9, text, font);
        stringWidget.m_269033_(color);
        return stringWidget;
    }

    public static void sendToast(Component name, Component description) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.NARRATOR_TOGGLE, name, description));
    }

    public static enum Align {
        VERTICAL,
        HORIZONTAL;

    }

    public static class MultilineLabelBox {
        private final StringWidget stringWidget;
        private final MultiLineEditBox multiLineEditBox;

        public MultilineLabelBox(Component text, Font font, int width, int height, int x, int y, Component placeholder) {
            this.stringWidget = ScreenUtils.text(text, font, x, y);
            this.multiLineEditBox = new MultiLineEditBox(font, x, y + this.stringWidget.m_93694_() + 5, width, height, placeholder, (Component)Component.m_237113_((String)""));
        }

        public void setPosition(int x, int y) {
            this.stringWidget.m_264152_(x, y);
            this.multiLineEditBox.m_264152_(x, y += this.stringWidget.m_93694_() + 5);
        }

        public StringWidget getStringWidget() {
            return this.stringWidget;
        }

        public MultiLineEditBox getMultiLineEditBox() {
            return this.multiLineEditBox;
        }
    }

    public static class LabelBox {
        private final StringWidget stringWidget;
        private final EditBox editBox;
        private final Align align;

        public LabelBox(Component text, Font font, int width, int height, int x, int y, Align align) {
            int yStringWidget = y;
            if (align == Align.HORIZONTAL) {
                Objects.requireNonNull(font);
                yStringWidget = (y += height / 2) - 9 / 2;
            }
            this.stringWidget = ScreenUtils.text(text, font, x, yStringWidget);
            if (align == Align.HORIZONTAL) {
                x = this.stringWidget.m_252754_() + this.stringWidget.m_5711_() + 5;
                y -= height / 2;
            } else if (align == Align.VERTICAL) {
                Objects.requireNonNull(font);
                y += 9 + 5;
            }
            this.editBox = new EditBox(font, x, y, width, height, (Component)Component.m_237113_((String)(text + " value")));
            this.align = align;
        }

        public void setPosition(int x, int y) {
            if (this.align == Align.HORIZONTAL) {
                this.stringWidget.m_264152_(x, y + this.editBox.m_93694_() / 2 - this.stringWidget.m_93694_() / 2);
            } else if (this.align == Align.VERTICAL) {
                this.stringWidget.m_264152_(x, y);
            }
            if (this.align == Align.HORIZONTAL) {
                x += this.stringWidget.m_5711_() + 5;
            } else if (this.align == Align.VERTICAL) {
                y = this.stringWidget.m_252907_() + this.stringWidget.m_93694_() + 5;
            }
            this.editBox.m_264152_(x, y);
        }

        public StringWidget getStringWidget() {
            return this.stringWidget;
        }

        public EditBox getEditBox() {
            return this.editBox;
        }
    }
}

