/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.files;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.character.CharacterModel;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.data.MainScreenData;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.story.StorySave;
import fr.loudo.narrativecraft.options.NarrativeClientOption;
import fr.loudo.narrativecraft.options.NarrativeWorldOption;
import fr.loudo.narrativecraft.serialization.AnimationSerializer;
import fr.loudo.narrativecraft.serialization.CharacterStoryDataSerializer;
import fr.loudo.narrativecraft.serialization.CutsceneSerializer;
import fr.loudo.narrativecraft.serialization.StorySaveSerializer;
import fr.loudo.narrativecraft.serialization.SubsceneSerializer;
import fr.loudo.narrativecraft.util.InkUtil;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.level.storage.LevelResource;

public class NarrativeCraftFile {
    public static final String EXTENSION_SCRIPT_FILE = ".ink";
    public static final String EXTENSION_DATA_FILE = ".json";
    private static final String DIRECTORY_NAME = "narrativecraft";
    public static final String DATA_FILE_NAME = "data.json";
    private static final String BUILD_DIRECTORY_NAME = "build";
    private static final String CHAPTERS_DIRECTORY_NAME = "chapters";
    private static final String CHARACTERS_DIRECTORY_NAME = "characters";
    private static final String SAVES_DIRECTORY_NAME = "saves";
    private static final String MAIN_INK_NAME = "main.ink";
    private static final String VARS_INK_NAME = "vars.ink";
    private static final String FUNCTIONS_INK_NAME = "funcs.ink";
    private static final String SCENES_DIRECTORY_NAME = "scenes";
    public static final String ANIMATIONS_FOLDER_NAME = "animations";
    public static final String NPC_FOLDER_NAME = "npc";
    public static final String DATA_FOLDER_NAME = "data";
    public static final String CAMERA_ANGLES_FILE_NAME = "camera_angles.json";
    public static final String CUTSCENES_FILE_NAME = "cutscenes.json";
    public static final String SUBSCENES_FILE_NAME = "subscenes.json";
    public static final String DIALOG_FILE_NAME = "dialog.json";
    public static final String SAVE_FILE_NAME = "save.json";
    public static final String STORY_FILE_NAME = "story.json";
    public static final String USER_OPTIONS_FILE_NAME = "user_options.json";
    public static final String WORLD_OPTIONS_FILE_NAME = "world_options.json";
    public static final String MAIN_SCREEN_BACKGROUND_FILE_NAME = "main_screen_background.json";
    public static final String SKINS_FOLDER_NAME = "skins";
    public static File rootDirectory;
    public static File mainDirectory;
    public static File chaptersDirectory;
    public static File characterDirectory;
    public static File savesDirectory;
    public static File buildDirectory;
    public static File dataDirectory;
    public static File mainInkFile;
    public static File varsInkFile;
    public static File functionsInkFile;

    public static void init(MinecraftServer server) {
        BufferedWriter writer;
        NarrativeCraftMod.firstTime = !new File(server.getWorldPath(LevelResource.ROOT).toFile(), DIRECTORY_NAME).exists();
        mainDirectory = NarrativeCraftFile.createDirectory(server.getWorldPath(LevelResource.ROOT).toFile(), DIRECTORY_NAME);
        rootDirectory = NarrativeCraftFile.createDirectory(Minecraft.getInstance().gameDirectory, DIRECTORY_NAME);
        chaptersDirectory = NarrativeCraftFile.createDirectory(mainDirectory, CHAPTERS_DIRECTORY_NAME);
        characterDirectory = NarrativeCraftFile.createDirectory(mainDirectory, CHARACTERS_DIRECTORY_NAME);
        savesDirectory = NarrativeCraftFile.createDirectory(mainDirectory, SAVES_DIRECTORY_NAME);
        buildDirectory = NarrativeCraftFile.createDirectory(mainDirectory, BUILD_DIRECTORY_NAME);
        dataDirectory = NarrativeCraftFile.createDirectory(mainDirectory, DATA_FOLDER_NAME);
        mainInkFile = NarrativeCraftFile.createFile(mainDirectory, MAIN_INK_NAME);
        if (!new File(mainDirectory, VARS_INK_NAME).exists()) {
            varsInkFile = NarrativeCraftFile.createFile(mainDirectory, VARS_INK_NAME);
            try {
                writer = new BufferedWriter(new FileWriter(varsInkFile));
                try {
                    writer.write("// " + Translation.message("file.vars_placeholder", new Object[0]).append("\n").append("\n").getString());
                }
                finally {
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                NarrativeCraftMod.LOGGER.warn("Couldn't write on vars ink file", (Throwable)e);
            }
        }
        if (!new File(mainDirectory, FUNCTIONS_INK_NAME).exists()) {
            functionsInkFile = NarrativeCraftFile.createFile(mainDirectory, FUNCTIONS_INK_NAME);
            try {
                writer = new BufferedWriter(new FileWriter(functionsInkFile));
                try {
                    writer.write("// " + Translation.message("file.funcs_placeholder", new Object[0]).append("\n").append("\n").getString());
                }
                finally {
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                NarrativeCraftMod.LOGGER.warn("Couldn't write on functions ink file", (Throwable)e);
            }
        }
    }

    private static File createDirectory(File parent, String name) {
        File directory = new File(parent, name);
        if (!directory.exists() && !directory.mkdir()) {
            NarrativeCraftMod.LOGGER.error("Couldn't create directory {}!", (Object)name);
        }
        return directory;
    }

    private static File createFile(File parent, String name) {
        File file = new File(parent, name);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    NarrativeCraftMod.LOGGER.error("Couldn't create file {}!", (Object)file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                NarrativeCraftMod.LOGGER.error("Couldn't create file {}! Cause: {}", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        return file;
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                NarrativeCraftFile.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }

    public static boolean saveExists() {
        return new File(savesDirectory, SAVE_FILE_NAME).exists();
    }

    public static String storyContent() throws IOException {
        return Files.readString(NarrativeCraftFile.getStoryFile().toPath());
    }

    public static StorySave saveContent() throws IOException {
        File saveFile = new File(savesDirectory, SAVE_FILE_NAME);
        String saveContent = Files.readString(saveFile.toPath());
        Gson gson = new GsonBuilder().registerTypeAdapter(StorySave.class, (Object)new StorySaveSerializer()).create();
        return (StorySave)gson.fromJson(saveContent, StorySave.class);
    }

    public static void writeSave(StorySave save) throws IOException {
        File saveFile = NarrativeCraftFile.createFile(savesDirectory, SAVE_FILE_NAME);
        Gson gson = new GsonBuilder().registerTypeAdapter(StorySave.class, (Object)new StorySaveSerializer()).create();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(saveFile));){
            gson.toJson((Object)save, (Appendable)writer);
        }
    }

    public static void removeSave() {
        File saveFile = new File(savesDirectory, SAVE_FILE_NAME);
        saveFile.delete();
    }

    public static File getStoryFile() {
        File buildFolder = NarrativeCraftFile.createDirectory(mainDirectory, BUILD_DIRECTORY_NAME);
        return new File(buildFolder, STORY_FILE_NAME);
    }

    public static MainScreenData getMainScreenBackground() throws IOException {
        String data;
        File mainBackgroundScreenFile = NarrativeCraftFile.createFile(dataDirectory, MAIN_SCREEN_BACKGROUND_FILE_NAME);
        Gson gson = new GsonBuilder().registerTypeAdapter(CharacterStoryData.class, (Object)new CharacterStoryDataSerializer(null)).create();
        MainScreenData mainScreenData = (MainScreenData)gson.fromJson(data = Files.readString(mainBackgroundScreenFile.toPath()), MainScreenData.class);
        return mainScreenData != null ? mainScreenData : new MainScreenData();
    }

    public static void updateMainScreenBackground(MainScreenData mainScreenData, Scene scene) throws IOException {
        File mainBackgroundScreenFile = NarrativeCraftFile.createFile(dataDirectory, MAIN_SCREEN_BACKGROUND_FILE_NAME);
        Gson gson = new GsonBuilder().registerTypeAdapter(CharacterStoryData.class, (Object)new CharacterStoryDataSerializer(scene)).create();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(mainBackgroundScreenFile));){
            gson.toJson((Object)mainScreenData, (Appendable)writer);
        }
    }

    public static void createChapterDirectory(Chapter chapter) throws IOException {
        File chapterFolder = NarrativeCraftFile.createDirectory(chaptersDirectory, String.valueOf(chapter.getIndex()));
        NarrativeCraftFile.createDirectory(chapterFolder.getAbsoluteFile(), SCENES_DIRECTORY_NAME);
        File chapterInkFile = NarrativeCraftFile.createFile(chapterFolder, "chapter_" + chapter.getIndex() + EXTENSION_SCRIPT_FILE);
        File dataFile = NarrativeCraftFile.getDataFile(chapterFolder);
        String content = String.format("{\"name\":\"%s\",\"description\":\"%s\"}", chapter.getName(), chapter.getDescription());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(dataFile));){
            writer.write(content);
        }
        writer = new BufferedWriter(new FileWriter(chapterInkFile));
        try {
            writer.write("=== " + chapter.knotName() + " ===");
        }
        finally {
            ((Writer)writer).close();
        }
        NarrativeCraftFile.updateInkIncludes();
    }

    public static void updateChapterData(Chapter chapter) throws IOException {
        File dataFile = NarrativeCraftFile.getDataFile(chapter);
        String content = String.format("{\"name\":\"%s\",\"description\":\"%s\"}", chapter.getName(), chapter.getDescription());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(dataFile));){
            writer.write(content);
        }
        NarrativeCraftFile.updateInkIncludes();
    }

    public static void deleteChapterDirectory(Chapter chapter) throws IOException {
        File chapterFolder = NarrativeCraftFile.getChapterDirectory(chapter);
        NarrativeCraftFile.deleteDirectory(chapterFolder);
        NarrativeCraftFile.updateInkIncludes();
    }

    public static void createSceneFolder(Scene scene) throws IOException {
        File chapterFolder = NarrativeCraftFile.createDirectory(chaptersDirectory, String.valueOf(scene.getChapter().getIndex()));
        File scenesFolder = NarrativeCraftFile.createDirectory(chapterFolder.getAbsoluteFile(), SCENES_DIRECTORY_NAME);
        File sceneFolder = NarrativeCraftFile.createDirectory(scenesFolder, Util.snakeCase(scene.getName()));
        File dataFolder = NarrativeCraftFile.createDirectory(sceneFolder, DATA_FOLDER_NAME);
        File dataFile = NarrativeCraftFile.getDataFile(dataFolder);
        File sceneInkFile = NarrativeCraftFile.createFile(sceneFolder, Util.snakeCase(scene.getName()) + EXTENSION_SCRIPT_FILE);
        NarrativeCraftFile.createDirectory(dataFolder, NPC_FOLDER_NAME);
        NarrativeCraftFile.createDirectory(dataFolder, ANIMATIONS_FOLDER_NAME);
        NarrativeCraftFile.createFile(dataFolder, CUTSCENES_FILE_NAME);
        NarrativeCraftFile.createFile(dataFolder, SUBSCENES_FILE_NAME);
        NarrativeCraftFile.createFile(dataFolder, CAMERA_ANGLES_FILE_NAME);
        String content = String.format("{\"name\":\"%s\",\"description\":\"%s\",\"rank\":%s}", scene.getName(), scene.getDescription(), scene.getRank());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(dataFile));){
            writer.write(content);
        }
        writer = new BufferedWriter(new FileWriter(sceneInkFile));
        try {
            writer.write("=== " + scene.knotName() + " ===\n# on enter");
        }
        finally {
            ((Writer)writer).close();
        }
        NarrativeCraftFile.updateMasterSceneKnot(scene);
    }

    public static void updateMasterSceneKnot(Scene scene) throws IOException {
        if (scene.getRank() > 1) {
            return;
        }
        File chapterInkFile = NarrativeCraftFile.getInkFile(scene.getChapter());
        String originalContent = Files.readString(chapterInkFile.toPath());
        Matcher matcher = InkUtil.SCENE_KNOT_PATTERN.matcher(originalContent);
        Object updatedContent = matcher.find() ? matcher.replaceFirst(scene.knotName()) : originalContent + "\n-> " + scene.knotName();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(chapterInkFile));){
            writer.write((String)updatedContent);
        }
    }

    public static void updateSceneData(Scene oldScene, Scene newScene) throws IOException {
        File sceneFolder = NarrativeCraftFile.getSceneFolder(oldScene);
        File newSceneFolder = new File(sceneFolder.getParent(), Util.snakeCase(newScene.getName()));
        if (!oldScene.getName().equalsIgnoreCase(newScene.getName())) {
            Files.move(sceneFolder.toPath(), newSceneFolder.toPath(), new CopyOption[0]);
            sceneFolder = newSceneFolder;
        }
        File sceneData = NarrativeCraftFile.getDataFile(newScene);
        String content = String.format("{\"name\":\"%s\",\"description\":\"%s\",\"rank\":%s}", newScene.getName(), newScene.getDescription(), newScene.getRank());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(sceneData));){
            writer.write(content);
        }
        File oldScriptFile = new File(sceneFolder, Util.snakeCase(oldScene.getName()) + EXTENSION_SCRIPT_FILE);
        File newScriptFile = new File(sceneFolder, Util.snakeCase(newScene.getName()) + EXTENSION_SCRIPT_FILE);
        Files.move(oldScriptFile.toPath(), newScriptFile.toPath(), new CopyOption[0]);
        String inkContent = Files.readString(newScriptFile.toPath());
        inkContent = inkContent.replace(oldScene.knotName(), newScene.knotName());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(newScriptFile));){
            writer.write(inkContent);
        }
        NarrativeCraftFile.updateMasterSceneKnot(newScene);
        NarrativeCraftFile.updateInkIncludes();
    }

    public static void updateSubsceneFile(Scene scene) throws IOException {
        File subsceneFile = NarrativeCraftFile.getSubsceneFile(scene);
        Gson gson = new GsonBuilder().registerTypeAdapter(Subscene.class, (Object)new SubsceneSerializer(scene)).create();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(subsceneFile));){
            gson.toJson(scene.getSubscenes(), (Appendable)writer);
        }
    }

    public static void updateCutsceneFile(Scene scene) throws IOException {
        File cutsceneFile = NarrativeCraftFile.getCutsceneFile(scene);
        Gson gson = new GsonBuilder().registerTypeAdapter(Cutscene.class, (Object)new CutsceneSerializer(scene)).create();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(cutsceneFile));){
            gson.toJson(scene.getCutscenes(), (Appendable)writer);
        }
    }

    public static void updateCameraAngles(Scene scene) throws IOException {
        File cameraAngelGroupFile = NarrativeCraftFile.getCameraAngelGroupFile(scene);
        Gson gson = new GsonBuilder().registerTypeAdapter(CharacterStoryData.class, (Object)new CharacterStoryDataSerializer(scene)).create();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(cameraAngelGroupFile));){
            gson.toJson(scene.getCameraAngles(), (Appendable)writer);
        }
    }

    public static void updateAnimationFile(Animation newAnimation) throws IOException {
        File animationsFolder = NarrativeCraftFile.getAnimationsFolder(newAnimation.getScene());
        File animationFile = NarrativeCraftFile.createFile(animationsFolder, Util.snakeCase(newAnimation.getName()) + EXTENSION_DATA_FILE);
        Gson gson = new GsonBuilder().registerTypeAdapter(Animation.class, (Object)new AnimationSerializer(newAnimation.getScene())).create();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(animationFile));){
            gson.toJson((Object)newAnimation, (Appendable)writer);
        }
    }

    public static void updateAnimationFile(Animation oldAnimation, Animation newAnimation) throws IOException {
        File animationsFolder = NarrativeCraftFile.getAnimationsFolder(newAnimation.getScene());
        NarrativeCraftFile.updateAnimationFile(newAnimation);
        new File(animationsFolder, Util.snakeCase(oldAnimation.getName()) + EXTENSION_DATA_FILE).delete();
    }

    public static void deleteAnimationFile(Animation animation) {
        File animationsFolder = NarrativeCraftFile.getAnimationsFolder(animation.getScene());
        new File(animationsFolder, Util.snakeCase(animation.getName()) + EXTENSION_DATA_FILE).delete();
    }

    public static void deleteSceneDirectory(Scene scene) throws IOException {
        File sceneFolder = NarrativeCraftFile.getSceneFolder(scene);
        NarrativeCraftFile.deleteDirectory(sceneFolder);
        NarrativeCraftFile.updateInkIncludes();
    }

    public static void createCharacterFolder(CharacterStory characterStory) throws IOException {
        File characterFolder = NarrativeCraftFile.getCharacterFolder(characterStory);
        File skinsFolder = NarrativeCraftFile.createDirectory(characterFolder, SKINS_FOLDER_NAME);
        File dataFile = NarrativeCraftFile.getDataFile(characterFolder);
        File mainSkinFile = NarrativeCraftFile.createFile(skinsFolder, "main.png");
        PlayerSkin defaultPlayerSkin = DefaultPlayerSkin.get((UUID)UUID.randomUUID());
        try (InputStream inputStream2 = Minecraft.getInstance().getResourceManager().open(defaultPlayerSkin.body().texturePath());){
            Files.copy(inputStream2, mainSkinFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException inputStream2) {
            // empty catch block
        }
        Gson gson = new Gson();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(dataFile));){
            gson.toJson((Object)characterStory, (Appendable)writer);
        }
        try {
            characterStory.setModel(CharacterModel.valueOf(defaultPlayerSkin.model().name()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void createCharacterFolder(CharacterStory characterStory, Scene scene) throws IOException {
        File characterFolder = NarrativeCraftFile.getCharacterFolder(characterStory, scene);
        File mainSkinFile = NarrativeCraftFile.createFile(characterFolder, "main.png");
        File dataFile = NarrativeCraftFile.createFile(characterFolder, DATA_FILE_NAME);
        PlayerSkin defaultPlayerSkin = DefaultPlayerSkin.get((UUID)UUID.randomUUID());
        try (InputStream inputStream2 = Minecraft.getInstance().getResourceManager().open(defaultPlayerSkin.body().texturePath());){
            Files.copy(inputStream2, mainSkinFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException inputStream2) {
            // empty catch block
        }
        Gson gson = new Gson();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(dataFile));){
            gson.toJson((Object)characterStory, (Appendable)writer);
        }
        try {
            characterStory.setModel(CharacterModel.valueOf(defaultPlayerSkin.model().name()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static List<File> getSkinFiles(CharacterStory characterStory) {
        File[] skinFiles = NarrativeCraftFile.createDirectory(NarrativeCraftFile.getCharacterFolder(characterStory), SKINS_FOLDER_NAME).listFiles();
        if (skinFiles == null) {
            return new ArrayList<File>();
        }
        return Arrays.stream(skinFiles).toList();
    }

    public static File getSkinFile(CharacterStory characterStory, Scene scene) {
        return new File(NarrativeCraftFile.getCharacterFolder(characterStory, scene), "main.png");
    }

    public static void updateCharacterData(CharacterStory oldCharacter, CharacterStory newCharacter) throws IOException {
        File dataFile = NarrativeCraftFile.getDataFile(oldCharacter);
        Gson gson = new Gson();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(dataFile));){
            gson.toJson((Object)newCharacter, (Appendable)writer);
        }
        File oldCharacterFolder = new File(characterDirectory, Util.snakeCase(oldCharacter.getName()));
        File newCharacterFolder = new File(characterDirectory, Util.snakeCase(newCharacter.getName()));
        Files.move(oldCharacterFolder.toPath(), newCharacterFolder.toPath(), new CopyOption[0]);
    }

    public static void updateCharacterData(CharacterStory oldCharacter, CharacterStory newCharacter, Scene scene) throws IOException {
        File npcFolder = NarrativeCraftFile.getNpcFolder(scene);
        File dataFile = NarrativeCraftFile.getDataFile(oldCharacter, scene);
        Gson gson = new Gson();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(dataFile));){
            gson.toJson((Object)newCharacter, (Appendable)writer);
        }
        File oldCharacterFolder = new File(npcFolder, Util.snakeCase(oldCharacter.getName()));
        File newCharacterFolder = new File(npcFolder, Util.snakeCase(newCharacter.getName()));
        Files.move(oldCharacterFolder.toPath(), newCharacterFolder.toPath(), new CopyOption[0]);
    }

    public static void deleteCharacterFolder(CharacterStory characterStory) {
        NarrativeCraftFile.deleteDirectory(NarrativeCraftFile.getCharacterFolder(characterStory));
    }

    public static void deleteCharacterFolder(CharacterStory characterStory, Scene scene) {
        NarrativeCraftFile.deleteDirectory(NarrativeCraftFile.getCharacterFolder(characterStory, scene));
    }

    public static File getChapterDirectory(Chapter chapter) {
        return NarrativeCraftFile.createDirectory(chaptersDirectory, String.valueOf(chapter.getIndex()));
    }

    public static File getChapterFolder(Chapter chapter) {
        return NarrativeCraftFile.createDirectory(chaptersDirectory, String.valueOf(chapter.getIndex()));
    }

    public static File getScenesFolder(Chapter chapter) {
        return NarrativeCraftFile.createDirectory(NarrativeCraftFile.getChapterDirectory(chapter), SCENES_DIRECTORY_NAME);
    }

    public static File getNpcFolder(Scene scene) {
        File dataFolder = NarrativeCraftFile.getDataFolder(scene);
        return NarrativeCraftFile.createDirectory(dataFolder, NPC_FOLDER_NAME);
    }

    public static void updateInkIncludes() throws IOException {
        List<Chapter> chapters = NarrativeCraftMod.getInstance().getChapterManager().getChapters();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("// ").append(Translation.message("file.main_ink_warning", new Object[0]).append("\n\n").getString());
        stringBuilder.append("INCLUDE funcs.ink").append("\n");
        stringBuilder.append("INCLUDE vars.ink").append("\n\n");
        for (Chapter chapter : chapters) {
            stringBuilder.append("// Chapter ").append(chapter.getIndex()).append("\n");
            String chapterInkFilePath = "chapters\\" + chapter.getIndex() + "\\" + chapter.knotName() + EXTENSION_SCRIPT_FILE;
            stringBuilder.append("INCLUDE ").append(chapterInkFilePath).append("\n");
            for (Scene scene : chapter.getSortedSceneList()) {
                String sceneInkFilePath = "chapters\\" + chapter.getIndex() + "\\scenes\\" + Util.snakeCase(scene.getName()) + "\\" + Util.snakeCase(scene.getName()) + EXTENSION_SCRIPT_FILE;
                stringBuilder.append("INCLUDE ").append(sceneInkFilePath).append("\n");
            }
            stringBuilder.append("\n");
        }
        if (!chapters.isEmpty()) {
            stringBuilder.append("->").append(chapters.getFirst().knotName());
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(mainInkFile));){
            writer.write(stringBuilder.toString());
        }
    }

    public static File getAnimationsFolder(Scene scene) {
        return NarrativeCraftFile.createDirectory(NarrativeCraftFile.getDataFolder(scene), ANIMATIONS_FOLDER_NAME);
    }

    public static File getSceneFolder(Scene scene) {
        File scenesFolder = NarrativeCraftFile.createFile(NarrativeCraftFile.getChapterDirectory(scene.getChapter()), SCENES_DIRECTORY_NAME);
        return NarrativeCraftFile.createDirectory(scenesFolder, Util.snakeCase(scene.getName()));
    }

    public static File getScriptFile(Scene scene) {
        return NarrativeCraftFile.createFile(NarrativeCraftFile.getSceneFolder(scene), Util.snakeCase(scene.getName()) + EXTENSION_SCRIPT_FILE);
    }

    public static File getScriptFile(Chapter chapter) {
        return NarrativeCraftFile.createFile(NarrativeCraftFile.getChapterFolder(chapter), "chapter_" + chapter.getIndex() + EXTENSION_SCRIPT_FILE);
    }

    public static File getSubsceneFile(Scene scene) {
        return NarrativeCraftFile.createFile(NarrativeCraftFile.getDataFolder(scene), SUBSCENES_FILE_NAME);
    }

    public static File getCutsceneFile(Scene scene) {
        return NarrativeCraftFile.createFile(NarrativeCraftFile.getDataFolder(scene), CUTSCENES_FILE_NAME);
    }

    public static File getCameraAngelGroupFile(Scene scene) {
        return NarrativeCraftFile.createFile(NarrativeCraftFile.getDataFolder(scene), CAMERA_ANGLES_FILE_NAME);
    }

    public static File getDataFolder(Scene scene) {
        File sceneFolder = NarrativeCraftFile.getSceneFolder(scene);
        return NarrativeCraftFile.createDirectory(sceneFolder, DATA_FOLDER_NAME);
    }

    public static File getCharacterFolder(CharacterStory characterStory) {
        return NarrativeCraftFile.createDirectory(characterDirectory, Util.snakeCase(characterStory.getName()));
    }

    public static File getCharacterFolder(CharacterStory characterStory, Scene scene) {
        return NarrativeCraftFile.createDirectory(NarrativeCraftFile.getNpcFolder(scene), Util.snakeCase(characterStory.getName()));
    }

    public static File getDataFile(Chapter chapter) {
        return NarrativeCraftFile.getDataFile(NarrativeCraftFile.getChapterDirectory(chapter));
    }

    public static File getDataFile(Scene scene) {
        File dataFolder = NarrativeCraftFile.createDirectory(NarrativeCraftFile.getSceneFolder(scene), DATA_FOLDER_NAME);
        return NarrativeCraftFile.createFile(dataFolder, DATA_FILE_NAME);
    }

    public static File getDataFile(CharacterStory characterStory) {
        return NarrativeCraftFile.createFile(NarrativeCraftFile.getCharacterFolder(characterStory), DATA_FILE_NAME);
    }

    public static File getDataFile(CharacterStory characterStory, Scene scene) {
        return NarrativeCraftFile.createFile(NarrativeCraftFile.getCharacterFolder(characterStory, scene), DATA_FILE_NAME);
    }

    public static File getDataFile(File file) {
        return NarrativeCraftFile.createFile(file, DATA_FILE_NAME);
    }

    public static File getDataFileFromSceneFolder(File sceneFile) {
        File dataFolder = NarrativeCraftFile.createDirectory(sceneFile, DATA_FOLDER_NAME);
        return NarrativeCraftFile.createFile(dataFolder, DATA_FILE_NAME);
    }

    public static File getInkFile(Chapter chapter) {
        File chapterFolder = NarrativeCraftFile.createDirectory(chaptersDirectory, String.valueOf(chapter.getIndex()));
        return NarrativeCraftFile.createFile(chapterFolder, "chapter_" + chapter.getIndex() + EXTENSION_SCRIPT_FILE);
    }

    public static File getInkFile(Scene scene) {
        File sceneFile = NarrativeCraftFile.getSceneFolder(scene);
        return NarrativeCraftFile.createFile(sceneFile, Util.snakeCase(scene.getName()) + EXTENSION_SCRIPT_FILE);
    }

    public static void updateUserOptions(NarrativeClientOption narrativeClientOption) {
        File userOptionsFile = NarrativeCraftFile.createFile(rootDirectory, USER_OPTIONS_FILE_NAME);
        try {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(userOptionsFile));){
                new Gson().toJson((Object)narrativeClientOption, (Appendable)writer);
            }
            catch (IOException e) {
                NarrativeCraftMod.LOGGER.error("Couldn't update user options! ", (Throwable)e);
            }
        }
        catch (JsonIOException e) {
            NarrativeCraftMod.LOGGER.error("Couldn't update user options! ", (Throwable)e);
        }
    }

    public static NarrativeClientOption loadUserOptions() {
        File userOptionsFile = NarrativeCraftFile.createFile(rootDirectory, USER_OPTIONS_FILE_NAME);
        try {
            String content = Files.readString(userOptionsFile.toPath());
            if (content.isEmpty()) {
                NarrativeCraftFile.updateUserOptions(new NarrativeClientOption());
            }
            NarrativeClientOption option = (NarrativeClientOption)new Gson().fromJson(content, NarrativeClientOption.class);
            return Objects.requireNonNullElseGet(option, NarrativeClientOption::new);
        }
        catch (IOException e) {
            NarrativeCraftMod.LOGGER.error("Couldn't read user options! ", (Throwable)e);
            return null;
        }
    }

    public static void updateWorldOptions(NarrativeWorldOption narrativeWorldOption) {
        File worldOptionsFile = NarrativeCraftFile.createFile(dataDirectory, WORLD_OPTIONS_FILE_NAME);
        try {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(worldOptionsFile));){
                new Gson().toJson((Object)narrativeWorldOption, (Appendable)writer);
            }
            catch (IOException e) {
                NarrativeCraftMod.LOGGER.error("Couldn't update world options! ", (Throwable)e);
            }
        }
        catch (JsonIOException e) {
            NarrativeCraftMod.LOGGER.error("Couldn't update world options! ", (Throwable)e);
        }
    }

    public static void updateWorldOptions(File worldOptionsFile, NarrativeWorldOption narrativeWorldOption) {
        try {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(worldOptionsFile));){
                new Gson().toJson((Object)narrativeWorldOption, (Appendable)writer);
            }
            catch (IOException e) {
                NarrativeCraftMod.LOGGER.error("Couldn't update world options! ", (Throwable)e);
            }
        }
        catch (JsonIOException e) {
            NarrativeCraftMod.LOGGER.error("Couldn't update world options! ", (Throwable)e);
        }
    }

    public static NarrativeWorldOption getNarrativeCraftWorldVersion(String levelName, String levelVersion) {
        File worldOptionFile = NarrativeCraftFile.getWorldOptionFile(levelName);
        if (!worldOptionFile.exists()) {
            return null;
        }
        try {
            String worldOptionContent = Files.readString(worldOptionFile.toPath());
            NarrativeWorldOption option = (NarrativeWorldOption)new Gson().fromJson(worldOptionContent, NarrativeWorldOption.class);
            if (option.stringMcVersion.isEmpty()) {
                option.stringMcVersion = levelVersion;
                NarrativeCraftFile.updateWorldOptions(worldOptionFile, option);
            }
            return option;
        }
        catch (IOException e) {
            NarrativeCraftMod.LOGGER.info("Can't get narrative craft world version of {}", (Object)levelName, (Object)e);
            return null;
        }
    }

    public static File getWorldOptionFile(String levelName) {
        Path path = Minecraft.getInstance().getLevelSource().getLevelPath(levelName);
        File narrativecraftFolder = new File(path.toFile(), DIRECTORY_NAME);
        File dataFolder = new File(narrativecraftFolder, DATA_FOLDER_NAME);
        return new File(dataFolder, WORLD_OPTIONS_FILE_NAME);
    }

    public static NarrativeWorldOption loadWorldOptions() {
        File worldOptionFile = NarrativeCraftFile.createFile(dataDirectory, WORLD_OPTIONS_FILE_NAME);
        try {
            String content = Files.readString(worldOptionFile.toPath());
            if (content.isEmpty()) {
                NarrativeCraftFile.updateWorldOptions(new NarrativeWorldOption());
            }
            NarrativeWorldOption option = (NarrativeWorldOption)new Gson().fromJson(content, NarrativeWorldOption.class);
            return Objects.requireNonNullElseGet(option, NarrativeWorldOption::new);
        }
        catch (IOException e) {
            NarrativeCraftMod.LOGGER.error("Couldn't read world options! ", (Throwable)e);
            return null;
        }
    }

    public static void createGlobalDialogValues() throws IOException {
        File dialogFile = new File(dataDirectory, DIALOG_FILE_NAME);
        if (dialogFile.exists()) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(dialogFile));){
            new Gson().toJson((Object)DialogData.globalDialogData, (Appendable)writer);
        }
    }

    public static DialogData getGlobalDialogValues() throws IOException {
        File dialogFile = NarrativeCraftFile.createFile(dataDirectory, DIALOG_FILE_NAME);
        String dialogContent = Files.readString(dialogFile.toPath());
        return (DialogData)new Gson().fromJson(dialogContent, DialogData.class);
    }

    public static void updateGlobalDialogValues(DialogData dialogData) throws IOException {
        File dialogFile = NarrativeCraftFile.createFile(dataDirectory, DIALOG_FILE_NAME);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(dialogFile));){
            new Gson().toJson((Object)dialogData, (Appendable)writer);
        }
    }
}

