/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.inkTag;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionRegistry;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.inkTag.InkTagHandlerException;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;

public class InkTagHandler {
    private final PlayerSession playerSession;
    private List<String> tagsToExecute = new ArrayList<String>();
    private Runnable run;

    public InkTagHandler(PlayerSession playerSession) {
        this.playerSession = playerSession;
    }

    public void execute() throws InkTagHandlerException {
        InkActionResult result = InkActionResult.ok();
        for (int i = 0; i < this.tagsToExecute.size(); ++i) {
            String tag = this.tagsToExecute.get(i);
            InkAction inkAction = InkActionRegistry.findByCommand(tag);
            if (inkAction == null) continue;
            inkAction.setBlockEndTask(() -> {
                inkAction.setRunning(false);
                try {
                    this.execute();
                }
                catch (InkTagHandlerException e) {
                    if (this.playerSession.getStoryHandler() == null) {
                        Util.sendCrashMessage((Player)this.playerSession.getPlayer(), e);
                    }
                    this.playerSession.getStoryHandler().showCrash(e);
                    this.playerSession.getStoryHandler().stop();
                }
            });
            result = inkAction.validate(tag, this.playerSession.getScene());
            if (result.isError()) {
                throw new InkTagHandlerException(inkAction.getClass(), result.errorMessage());
            }
            result = inkAction.execute(this.playerSession);
            if (result.isIgnore()) {
                inkAction.setRunning(false);
            }
            this.playerSession.addInkAction(inkAction);
            if (!result.isBlock()) continue;
            this.tagsToExecute = this.tagsToExecute.subList(i + 1, this.tagsToExecute.size());
            return;
        }
        this.tagsToExecute.clear();
        StoryHandler storyHandler = this.playerSession.getStoryHandler();
        if (storyHandler != null && this.tagsToExecute.isEmpty() && result.isOk()) {
            if (storyHandler.isFinished() && storyHandler.getDialogText().isEmpty()) {
                storyHandler.stopAndFinishScreen();
            } else {
                storyHandler.showCurrentDialog();
            }
        }
        if (this.run != null) {
            this.run.run();
        }
    }

    public void stopAll() {
        for (InkAction inkAction : this.playerSession.getInkActions()) {
            inkAction.stop();
        }
    }

    public PlayerSession getPlayerSession() {
        return this.playerSession;
    }

    public List<String> getTagsToExecute() {
        return this.tagsToExecute;
    }

    public Runnable getRun() {
        return this.run;
    }

    public void setRun(Runnable run) {
        this.run = run;
    }
}

