/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.keyframes;

import com.mojang.datafixers.util.Pair;
import fr.loudo.narrativecraft.items.CutsceneEditItems;
import fr.loudo.narrativecraft.mixin.invoker.ArmorStandInvoker;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.util.MathHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Keyframe {
    protected transient ArmorStand camera;
    protected final int id;
    protected KeyframeLocation keyframeLocation;

    public Keyframe(int id, KeyframeLocation keyframeLocation) {
        this.id = id;
        this.keyframeLocation = keyframeLocation;
    }

    public void showKeyframe(ServerPlayer player) {
        this.camera = new ArmorStand(EntityType.ARMOR_STAND, (Level)player.level());
        ((ArmorStandInvoker)this.camera).callSetSmall(true);
        this.camera.setNoGravity(true);
        this.camera.setInvisible(true);
        this.camera.setNoBasePlate(true);
        this.camera.setBodyPose(new Rotations(180.0f, 0.0f, 0.0f));
        this.camera.setLeftLegPose(new Rotations(180.0f, 0.0f, 0.0f));
        this.camera.setRightLegPose(new Rotations(180.0f, 0.0f, 0.0f));
        BlockPos blockPos = new BlockPos((int)this.keyframeLocation.getX(), (int)this.keyframeLocation.getY(), (int)this.keyframeLocation.getZ());
        player.connection.send((Packet)new ClientboundAddEntityPacket((Entity)this.camera, 0, blockPos));
        player.connection.send((Packet)new ClientboundSetEquipmentPacket(this.camera.getId(), List.of(new Pair((Object)EquipmentSlot.HEAD, (Object)CutsceneEditItems.camera))));
        this.updateEntityData(player);
    }

    public void hideKeyframe(ServerPlayer player) {
        player.connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{this.camera.getId()}));
    }

    public void updateEntityData(ServerPlayer player) {
        float pitchHeadPos = MathHelper.wrapDegrees360(this.keyframeLocation.getPitch());
        this.camera.setHeadPose(new Rotations(pitchHeadPos == 0.0f ? 1.0E-6f : MathHelper.wrapDegrees360(this.keyframeLocation.getPitch()), 0.0f, this.keyframeLocation.getRoll()));
        this.camera.setXRot(this.keyframeLocation.getPitch());
        this.camera.setYRot(this.keyframeLocation.getYaw());
        this.camera.setYHeadRot(this.keyframeLocation.getYaw());
        Vec3 playerCoordVec3 = new Vec3(this.keyframeLocation.getX(), this.keyframeLocation.getY() - 1.0, this.keyframeLocation.getZ());
        PositionMoveRotation pos = new PositionMoveRotation(playerCoordVec3, new Vec3(0.0, 0.0, 0.0), this.keyframeLocation.getYaw(), this.keyframeLocation.getPitch());
        player.connection.send((Packet)new ClientboundEntityPositionSyncPacket(this.camera.getId(), pos, false));
        player.connection.send((Packet)new ClientboundSetEntityDataPacket(this.camera.getId(), this.camera.getEntityData().getNonDefaultValues()));
    }

    public int getId() {
        return this.id;
    }

    public ArmorStand getCamera() {
        return this.camera;
    }

    public KeyframeLocation getKeyframeLocation() {
        return this.keyframeLocation;
    }

    public void setKeyframeLocation(KeyframeLocation keyframeLocation) {
        this.keyframeLocation = keyframeLocation;
    }
}

