/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.util.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class NarrativeCraftLogoRenderer {
    public static final ResourceLocation LOGO = ResourceLocation.withDefaultNamespace((String)"textures/narrativecraft_logo.png");
    private final ResourceLocation resourceLocation;
    private int[] logoRes;
    private int imageHeight;

    public NarrativeCraftLogoRenderer(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void init() {
        this.logoRes = Util.getImageResolution(LOGO);
        if (this.logoRes != null) {
            this.imageHeight = Util.getDynamicHeight(this.logoRes, 256);
        }
    }

    public boolean logoExists() {
        return Util.resourceExists(this.resourceLocation);
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, LOGO, x, y, 0.0f, 0.0f, 256, this.imageHeight, 256, this.imageHeight, ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int[] getLogoRes() {
        return this.logoRes;
    }
}

