/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.keyframe;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionRegistry;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.controllers.mainScreen.MainScreenController;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import fr.loudo.narrativecraft.narrative.story.inkAction.OnEnterInkAction;
import fr.loudo.narrativecraft.narrative.story.inkAction.SaveInkAction;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class KeyframeTriggerScreen
extends Screen {
    private final int gap = 5;
    private final int tickBoxHeight = 20;
    private final int tickBoxWidth = 60;
    private final int commandBoxHeight = 120;
    private final int globalWidth = 240;
    private int defaultTick;
    private ScreenUtils.LabelBox tickBox;
    private ScreenUtils.MultilineLabelBox commandBox;
    private AbstractKeyframeController<? extends Keyframe> controller;
    private KeyframeTrigger keyframeTrigger;

    public KeyframeTriggerScreen(AbstractKeyframeController<? extends Keyframe> controller, KeyframeTrigger keyframeTrigger) {
        super((Component)Component.literal((String)"Keyframe Trigger Screen"));
        this.controller = controller;
        this.keyframeTrigger = keyframeTrigger;
        this.defaultTick = keyframeTrigger.getTick();
    }

    public KeyframeTriggerScreen(AbstractKeyframeController<? extends Keyframe> controller, int defaultTick) {
        super((Component)Component.literal((String)"Keyframe Trigger Screen"));
        this.controller = controller;
        this.defaultTick = defaultTick;
    }

    protected void init() {
        int totalHeight = 195;
        if (this.keyframeTrigger != null) {
            totalHeight += 45;
        }
        int startY = (this.height - totalHeight) / 2;
        int xGlobal = (this.width - 240) / 2;
        Objects.requireNonNull(this.minecraft.font);
        StringWidget tagWidget = new StringWidget(0, startY - 9 - 30, 100, 40, (Component)Component.empty(), this.minecraft.font);
        this.addRenderableWidget((GuiEventListener)tagWidget);
        Objects.requireNonNull(this.minecraft.font);
        StringWidget errorWidget = new StringWidget(0, startY - 9 - 20, 100, 40, (Component)Component.empty(), this.minecraft.font);
        this.addRenderableWidget((GuiEventListener)errorWidget);
        int currentY = startY;
        this.tickBox = new ScreenUtils.LabelBox((Component)Component.literal((String)"Tick"), this.minecraft.font, 60, 20, xGlobal, currentY, ScreenUtils.Align.HORIZONTAL);
        this.tickBox.getEditBox().setFilter(s -> s.matches("^(?:[0-9]+)?$"));
        this.addRenderableWidget((GuiEventListener)this.tickBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.tickBox.getEditBox());
        this.commandBox = new ScreenUtils.MultilineLabelBox((Component)Component.literal((String)"Tags"), this.minecraft.font, 240, 120, xGlobal, currentY += 25, (Component)Component.literal((String)"animation start cathy_walk\ntime set 6000 to 90000 for 6 seconds\n..."));
        this.addRenderableWidget((GuiEventListener)this.commandBox.getStringWidget());
        this.addRenderableWidget((GuiEventListener)this.commandBox.getMultiLineEditBox());
        Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            List<String> tags = Arrays.asList(this.commandBox.getMultiLineEditBox().getValue().split("\n"));
            for (String tag : tags) {
                String stringTag = "\"" + tag + "\"";
                int tagWidth = this.minecraft.font.width(stringTag);
                tagWidget.setWidth(tagWidth);
                tagWidget.setX(this.width / 2 - tagWidth / 2);
                InkAction inkAction = InkActionRegistry.findByCommand(tag);
                if (inkAction instanceof SaveInkAction || inkAction instanceof OnEnterInkAction) {
                    this.showError(tagWidget, errorWidget, stringTag, (Component)Translation.message("ink_action.not_authorized", stringTag));
                    return;
                }
                if (inkAction == null) {
                    this.showError(tagWidget, errorWidget, stringTag, (Component)Translation.message("ink_action.no_exists", new Object[0]));
                    return;
                }
                if (this.controller instanceof MainScreenController && inkAction.needScene()) {
                    this.showError(tagWidget, errorWidget, stringTag, (Component)Translation.message("ink_action.not_authorized", stringTag));
                    return;
                }
                InkActionResult result = inkAction.validate(tag, this.controller.getPlayerSession().getScene());
                if (!result.isError()) continue;
                this.showError(tagWidget, errorWidget, stringTag, (Component)Component.literal((String)result.errorMessage()));
                return;
            }
            int tick = this.defaultTick;
            try {
                tick = Integer.parseInt(this.tickBox.getEditBox().getValue());
            }
            catch (NumberFormatException tag) {
                // empty catch block
            }
            String commands = this.commandBox.getMultiLineEditBox().getValue();
            if (this.keyframeTrigger == null) {
                this.controller.addKeyframeTrigger(tick, commands);
            } else {
                this.keyframeTrigger.setTick(tick);
                this.keyframeTrigger.setCommands(commands);
            }
            this.onClose();
        }).width(240).pos(xGlobal, currentY += 120 + this.commandBox.getStringWidget().getHeight() + 10).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        Button closeButton = Button.builder((Component)Translation.message("global.close", new Object[0]), button -> this.onClose()).width(240).pos(xGlobal, currentY += 25).build();
        this.addRenderableWidget((GuiEventListener)closeButton);
        if (this.keyframeTrigger != null) {
            Button removeButton = Button.builder((Component)Translation.message("global.remove", new Object[0]), button -> {
                ConfirmScreen confirmScreen = new ConfirmScreen(b -> {
                    if (b) {
                        this.controller.removeKeyframeTrigger(this.keyframeTrigger);
                        this.onClose();
                    } else {
                        KeyframeTriggerScreen screen = new KeyframeTriggerScreen(this.controller, this.keyframeTrigger);
                        this.minecraft.setScreen((Screen)screen);
                    }
                }, (Component)Component.literal((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
                this.minecraft.setScreen((Screen)confirmScreen);
            }).width(240).pos(xGlobal, currentY += 25).build();
            this.addRenderableWidget((GuiEventListener)removeButton);
        }
        if (this.keyframeTrigger != null) {
            this.tickBox.getEditBox().setValue(String.valueOf(this.keyframeTrigger.getTick()));
            this.commandBox.getMultiLineEditBox().setValue(this.keyframeTrigger.getCommands());
        } else {
            this.tickBox.getEditBox().setValue(String.valueOf(this.defaultTick));
        }
    }

    private void showError(StringWidget tagWidget, StringWidget errorWidget, String stringTag, Component errorMessage) {
        tagWidget.setMessage((Component)Component.literal((String)stringTag).withStyle(ChatFormatting.RED));
        errorWidget.setMessage((Component)errorMessage.copy().withStyle(ChatFormatting.RED));
        int errorWidth = this.minecraft.font.width((FormattedText)errorMessage);
        errorWidget.setWidth(errorWidth);
        errorWidget.setX(this.width / 2 - errorWidth / 2);
    }
}

