/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionRegistry;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.controller.cutscene.CutsceneKeyframeOptionScreen;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.MathHelper;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class CutscenePlayback {
    private final CutsceneController cutsceneController;
    private final PlayerSession playerSession;
    private final Runnable onCutsceneEnd;
    private CutsceneKeyframe keyframeA;
    private CutsceneKeyframe keyframeB;
    private CutsceneKeyframeGroup currentKeyframeGroup;
    private int segmentTick;
    private int totalTick;
    private boolean isPlaying;

    public CutscenePlayback(CutsceneController cutsceneController, Runnable onCutsceneEnd) {
        this.cutsceneController = cutsceneController;
        this.playerSession = cutsceneController.getPlayerSession();
        this.onCutsceneEnd = onCutsceneEnd;
    }

    public void setupAndPlay(CutsceneKeyframe keyframeA, CutsceneKeyframe keyframeB) {
        this.keyframeA = keyframeA;
        this.keyframeB = keyframeB;
        this.currentKeyframeGroup = (CutsceneKeyframeGroup)this.cutsceneController.getKeyframeGroupOfKeyframe(keyframeA);
        this.cutsceneController.setPlaying(true);
        this.segmentTick = 0;
        this.totalTick = keyframeA.getTick();
        class_310.method_1551().field_1690.field_1842 = true;
        this.play();
    }

    public void play() {
        this.isPlaying = true;
    }

    public void stop() {
        this.isPlaying = false;
    }

    public void tick() {
        if (!this.isPlaying) {
            return;
        }
        if (class_310.method_1551().field_1690.field_1832.method_1434() && this.cutsceneController.getEnvironment() == Environment.DEVELOPMENT) {
            this.stop();
            this.playerSession.setCurrentCamera(this.keyframeA.getKeyframeLocation());
            class_310.method_1551().method_1507((class_437)new CutsceneKeyframeOptionScreen(this.keyframeA, this.playerSession, false));
            this.cutsceneController.changeTimePosition(this.keyframeA.getTick(), true);
            this.cutsceneController.setPlaying(false);
        }
        List<KeyframeTrigger> keyframeTriggersToExecute = this.cutsceneController.getKeyframeTriggers().stream().filter(trigger -> trigger.getTick() == this.totalTick).toList();
        NarrativeCraftMod.server.execute(() -> {
            for (KeyframeTrigger keyframeTrigger : keyframeTriggersToExecute) {
                for (String command : keyframeTrigger.getCommandsToList()) {
                    InkActionResult result;
                    InkAction inkAction = InkActionRegistry.findByCommand(command);
                    if (inkAction == null || !(result = inkAction.validateAndExecute(command, this.playerSession)).isOk()) continue;
                    this.playerSession.addInkAction(inkAction);
                }
            }
        });
        ++this.segmentTick;
        ++this.totalTick;
    }

    public void cameraInterpolation(double partialTick) {
        if (!this.isPlaying) {
            return;
        }
        if ((double)this.segmentTick + partialTick < (double)this.keyframeA.getStartDelayTick()) {
            this.playerSession.setCurrentCamera(this.keyframeA.getKeyframeLocation());
            return;
        }
        double totalDelta = class_3532.method_15350((double)(((double)this.segmentTick + partialTick - (double)this.keyframeA.getStartDelayTick()) / (double)this.keyframeB.getPathTick()), (double)0.0, (double)1.0);
        if (this.keyframeB.getEasing() != Easing.SMOOTH || this.currentKeyframeGroup.getKeyframes().size() < 2) {
            totalDelta = this.keyframeB.getEasing().interpolate(totalDelta);
            this.playerSession.setCurrentCamera(this.interpolate(totalDelta / this.keyframeB.getSpeed(), this.keyframeA.getKeyframeLocation(), this.keyframeB.getKeyframeLocation()));
        } else {
            KeyframeLocation location = this.interpolateByCatmull(partialTick);
            this.playerSession.setCurrentCamera(location);
        }
        double extraDelay = 0.0;
        if (this.currentKeyframeGroup.isLastKeyframe(this.keyframeB)) {
            extraDelay += (double)this.keyframeB.getTransitionDelayTick();
        }
        if (totalDelta >= 1.0 && (double)this.segmentTick >= (double)(this.keyframeB.getPathTick() + this.keyframeA.getStartDelayTick()) + extraDelay) {
            if (this.cutsceneController.isLastKeyframe(this.keyframeB)) {
                this.onEnd();
            } else {
                this.pickNextKeyframes();
            }
        }
    }

    private KeyframeLocation interpolateByCatmull(double partialTick) {
        CutsceneKeyframe keyframe;
        List keyframes = this.currentKeyframeGroup.getKeyframes();
        if (keyframes.size() < 2) {
            return ((CutsceneKeyframe)keyframes.getLast()).getKeyframeLocation();
        }
        int startIndex = 0;
        Iterator iterator = keyframes.iterator();
        while (iterator.hasNext() && (keyframe = (CutsceneKeyframe)iterator.next()).getId() != this.keyframeA.getId()) {
            ++startIndex;
        }
        double elapsedTick = (double)this.segmentTick + partialTick;
        elapsedTick = elapsedTick >= (double)this.keyframeA.getStartDelayTick() ? (elapsedTick -= (double)this.keyframeA.getStartDelayTick()) : 0.0;
        int accumulatedTick = 0;
        for (int i = startIndex; i < keyframes.size() - 1; ++i) {
            CutsceneKeyframe k1 = (CutsceneKeyframe)keyframes.get(i);
            CutsceneKeyframe k2 = (CutsceneKeyframe)keyframes.get(i + 1);
            int segmentDuration = (int)((double)k2.getPathTick() / k2.getSpeed());
            if (elapsedTick < (double)(accumulatedTick + segmentDuration)) {
                double t = (elapsedTick - (double)accumulatedTick) / (double)segmentDuration;
                CutsceneKeyframe p0 = (CutsceneKeyframe)keyframes.get(Math.max(i - 1, 0));
                CutsceneKeyframe p1 = k1;
                CutsceneKeyframe p2 = k2;
                CutsceneKeyframe p3 = (CutsceneKeyframe)keyframes.get(Math.min(i + 2, keyframes.size() - 1));
                return this.catmullRom(p0.getKeyframeLocation(), p1.getKeyframeLocation(), p2.getKeyframeLocation(), p3.getKeyframeLocation(), t);
            }
            accumulatedTick += segmentDuration;
        }
        return ((CutsceneKeyframe)keyframes.getLast()).getKeyframeLocation();
    }

    private KeyframeLocation catmullRom(KeyframeLocation p0, KeyframeLocation p1, KeyframeLocation p2, KeyframeLocation p3, double t) {
        double x = MathHelper.catmullRom((float)p0.getX(), (float)p1.getX(), (float)p2.getX(), (float)p3.getX(), (float)t);
        double y = MathHelper.catmullRom((float)p0.getY(), (float)p1.getY(), (float)p2.getY(), (float)p3.getY(), (float)t);
        double z = MathHelper.catmullRom((float)p0.getZ(), (float)p1.getZ(), (float)p2.getZ(), (float)p3.getZ(), (float)t);
        float pitch = MathHelper.catmullRom(p0.getPitch(), p1.getPitch(), p2.getPitch(), p3.getPitch(), (float)t);
        float yaw = CutscenePlayback.interpolateAngleCatmullRom(p0.getYaw(), p1.getYaw(), p2.getYaw(), p3.getYaw(), t);
        float fov = MathHelper.catmullRom(p0.getFov(), p1.getFov(), p2.getFov(), p3.getFov(), (float)t);
        float roll = CutscenePlayback.interpolateAngleCatmullRom(p0.getRoll(), p1.getRoll(), p2.getRoll(), p3.getRoll(), t);
        return new KeyframeLocation(x, y, z, pitch, yaw, roll, fov);
    }

    private void onEnd() {
        this.stop();
        this.playerSession.setCurrentCamera(this.keyframeB.getKeyframeLocation());
        if (this.cutsceneController.getEnvironment() == Environment.DEVELOPMENT) {
            CutsceneKeyframeOptionScreen screen = new CutsceneKeyframeOptionScreen(this.keyframeB, this.playerSession, false);
            class_310.method_1551().method_1507((class_437)screen);
            this.cutsceneController.setCurrentTick(this.keyframeB.getTick());
            this.cutsceneController.pause();
        }
    }

    private void pickNextKeyframes() {
        CutsceneKeyframeGroup cutsceneKeyframeGroupB;
        if (this.currentKeyframeGroup.getKeyframes().size() == 1) {
            this.keyframeB = this.cutsceneController.getNextKeyframe(this.keyframeB);
        }
        if ((cutsceneKeyframeGroupB = (CutsceneKeyframeGroup)this.cutsceneController.getKeyframeGroupOfKeyframe(this.keyframeB)).getKeyframes().size() == 1) {
            this.keyframeA = (CutsceneKeyframe)cutsceneKeyframeGroupB.getKeyframes().getFirst();
        } else if (this.currentKeyframeGroup.getId() != cutsceneKeyframeGroupB.getId()) {
            this.keyframeA = (CutsceneKeyframe)cutsceneKeyframeGroupB.getKeyframes().getFirst();
            this.keyframeB = this.cutsceneController.getNextKeyframe(this.keyframeA);
        } else {
            this.keyframeA = this.keyframeB;
            this.keyframeB = this.cutsceneController.getNextKeyframe(this.keyframeB);
        }
        this.segmentTick = 0;
        this.currentKeyframeGroup = (CutsceneKeyframeGroup)this.cutsceneController.getKeyframeGroupOfKeyframe(this.keyframeB);
        this.playerSession.setCurrentCamera(this.keyframeA.getKeyframeLocation());
    }

    public KeyframeLocation interpolate(double delta, KeyframeLocation a, KeyframeLocation b) {
        if (!this.isPlaying) {
            return null;
        }
        class_243 position = class_3532.method_61342((double)delta, (class_243)a.getPosition(), (class_243)b.getPosition());
        float pitch = (float)class_3532.method_16436((double)delta, (double)a.getPitch(), (double)b.getPitch());
        float yaw = CutscenePlayback.interpolateAngle(a.getYaw(), b.getYaw(), delta);
        float roll = CutscenePlayback.interpolateAngle(a.getRoll(), b.getRoll(), delta);
        float fov = (float)class_3532.method_16436((double)delta, (double)a.getFov(), (double)b.getFov());
        return new KeyframeLocation(position, pitch, yaw, roll, fov);
    }

    private static float getShortestAngleDifference(float from, float to) {
        float diff = to - from;
        if (diff > 180.0f) {
            diff -= 360.0f;
        } else if (diff < -180.0f) {
            diff += 360.0f;
        }
        return diff;
    }

    private static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle <= -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static float interpolateAngle(float from, float to, double t) {
        float diff = CutscenePlayback.getShortestAngleDifference(from, to);
        return CutscenePlayback.normalizeAngle(from + (float)((double)diff * t));
    }

    private static float unwrapAngle(float angle, float reference) {
        return reference + CutscenePlayback.getShortestAngleDifference(reference, angle);
    }

    private static float interpolateAngleCatmullRom(float a0, float a1, float a2, float a3, double t) {
        a0 = CutscenePlayback.unwrapAngle(a0, a1);
        a2 = CutscenePlayback.unwrapAngle(a2, a1);
        a3 = CutscenePlayback.unwrapAngle(a3, a2);
        double t2 = t * t;
        double t3 = t2 * t;
        float angle = (float)(0.5 * (2.0 * (double)a1 + (double)(-a0 + a2) * t + (2.0 * (double)a0 - 5.0 * (double)a1 + 4.0 * (double)a2 - (double)a3) * t2 + ((double)(-a0) + 3.0 * (double)a1 - 3.0 * (double)a2 + (double)a3) * t3));
        return CutscenePlayback.normalizeAngle(angle);
    }

    public CutsceneKeyframe getKeyframeA() {
        return this.keyframeA;
    }

    public void setKeyframeA(CutsceneKeyframe keyframeA) {
        this.keyframeA = keyframeA;
    }

    public CutsceneKeyframe getKeyframeB() {
        return this.keyframeB;
    }

    public void setKeyframeB(CutsceneKeyframe keyframeB) {
        this.keyframeB = keyframeB;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public int getSegmentTick() {
        return this.segmentTick;
    }

    public void setSegmentTick(int segmentTick) {
        this.segmentTick = segmentTick;
    }

    public int getTotalTick() {
        return this.totalTick;
    }

    public void setTotalTick(int totalTick) {
        this.totalTick = totalTick;
    }
}

