/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import com.mojang.authlib.GameProfile;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.MainCharacterAttribute;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Util;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.class_12079;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_7920;
import net.minecraft.class_8685;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_640.class})
public class PlayerInfoMixin {
    @Shadow
    @Final
    private GameProfile field_3741;

    @Inject(method={"getProfile"}, at={@At(value="RETURN")}, cancellable=true)
    private void narrativecraft$getProfile(CallbackInfoReturnable<GameProfile> callbackInfo) {
        if (!"_username_".equals(this.field_3741.name())) {
            return;
        }
        GameProfile originalProfile = (GameProfile)callbackInfo.getReturnValue();
        String playerName = class_310.method_1551().field_1724.method_5477().getString();
        callbackInfo.setReturnValue((Object)new GameProfile(originalProfile.id(), playerName));
    }

    @Inject(method={"getSkin"}, at={@At(value="RETURN")}, cancellable=true)
    private void narrativecraft$getSkin(CallbackInfoReturnable<class_8685> callbackInfo) {
        class_2960 mainCharacterSkin;
        CharacterStory mainCharacter;
        class_310 minecraft = class_310.method_1551();
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)minecraft.field_1724);
        if (playerSession == null) {
            return;
        }
        if (minecraft.field_1724.method_7334().equals((Object)this.field_3741) && playerSession.getStoryHandler() != null && (mainCharacter = NarrativeCraftMod.getInstance().getCharacterManager().getMainCharacter()) != null && mainCharacter.getMainCharacterAttribute().isSameSkinAsTheir() && (mainCharacterSkin = NarrativeCraftFile.getMainCharacterSkin()) != null) {
            class_7920 playerModelType;
            try {
                playerModelType = class_7920.valueOf((String)mainCharacter.getModel().name());
            }
            catch (IllegalArgumentException exception) {
                playerModelType = class_7920.field_41123;
            }
            class_8685 playerSkin = class_8685.method_74884((class_12079.class_12081)new class_12079.class_10726(mainCharacterSkin, mainCharacterSkin), null, null, (class_7920)playerModelType);
            callbackInfo.setReturnValue((Object)playerSkin);
            return;
        }
        for (CharacterRuntime characterRuntime : new ArrayList<CharacterRuntime>(playerSession.getCharacterRuntimes())) {
            class_7920 playerModelType;
            if (characterRuntime.getEntity() == null) continue;
            CharacterStory characterStory = characterRuntime.getCharacterStory();
            MainCharacterAttribute mainCharacterAttribute = characterStory.getMainCharacterAttribute();
            try {
                playerModelType = class_7920.valueOf((String)characterStory.getModel().name());
            }
            catch (IllegalArgumentException exception) {
                playerModelType = class_7920.field_41123;
            }
            File currentSkinFile = characterRuntime.getCharacterSkinController().getCurrentSkin();
            if (currentSkinFile == null) continue;
            class_2960 skinLocation = class_2960.method_60655((String)"narrativecraft", (String)("character/" + Util.snakeCase(characterStory.getName()) + "/" + Util.snakeCase(currentSkinFile.getName())));
            class_8685 playerSkin = class_8685.method_74884((class_12079.class_12081)new class_12079.class_10726(skinLocation, skinLocation), null, null, (class_7920)playerModelType);
            if (!this.field_3741.name().equals(characterStory.getName())) continue;
            if (mainCharacterAttribute.isMainCharacter() && mainCharacterAttribute.isSameSkinAsPlayer()) {
                callbackInfo.setReturnValue((Object)minecraft.field_1724.method_52814());
                return;
            }
            callbackInfo.setReturnValue((Object)playerSkin);
        }
    }
}

