/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.animation;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.gui.ICustomGuiRender;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer2D;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import fr.loudo.narrativecraft.narrative.dialog.animation.AbstractDialogScrollText;
import fr.loudo.narrativecraft.options.NarrativeClientOption;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9848;
import org.joml.Vector2f;

public class DialogScrollTextDialog
extends AbstractDialogScrollText {
    private final DialogRenderer dialogRenderer;

    public DialogScrollTextDialog(DialogRenderer dialogRenderer, class_310 minecraft) {
        super(minecraft);
        this.dialogRenderer = dialogRenderer;
        this.setText(dialogRenderer.getText());
        NarrativeClientOption clientOption = NarrativeCraftMod.getInstance().getNarrativeClientOptions();
        this.textSpeed = clientOption.textSpeed;
        this.letterSpacing = dialogRenderer.getLetterSpacing();
        this.gap = dialogRenderer.getGap();
        this.textColor = dialogRenderer.getTextColor();
    }

    @Override
    protected List<String> splitTextIntoLines(String text) {
        return Util.splitText(text, this.minecraft.field_1772, (int)this.dialogRenderer.getWidth());
    }

    @Override
    protected float getInitialX() {
        return -this.dialogRenderer.getTotalWidth() + this.dialogRenderer.getPaddingX() * 2.0f;
    }

    @Override
    protected float getInitialY() {
        if (this.dialogRenderer instanceof DialogRenderer2D) {
            if (this.lines.size() > 1) {
                Objects.requireNonNull(this.minecraft.field_1772);
                float f = (9.0f + this.dialogRenderer.getGap()) * (float)(this.lines.size() - 1);
                Objects.requireNonNull(this.minecraft.field_1772);
                return -((f + 9.0f) / 2.0f + 0.7f);
            }
            Objects.requireNonNull(this.minecraft.field_1772);
            return (float)(-9) / 2.0f;
        }
        return -this.dialogRenderer.getTotalHeight() + this.dialogRenderer.getPaddingY() + 0.7f;
    }

    @Override
    protected boolean canScroll() {
        return !this.dialogRenderer.isAnimating();
    }

    public void render(class_4587 poseStack, class_4597.class_4598 source, float partialTick) {
        Map<Integer, Vector2f> offsets = this.getTextEffectOffsets(partialTick);
        for (int i = 0; i < this.lettersRenderer.size(); ++i) {
            AbstractDialogScrollText.LetterLocation letter = (AbstractDialogScrollText.LetterLocation)this.lettersRenderer.get(i);
            if (!letter.render()) continue;
            float x = letter.x();
            float y = letter.y();
            if (offsets.containsKey(i)) {
                x += offsets.get((Object)Integer.valueOf((int)i)).x;
                y += offsets.get((Object)Integer.valueOf((int)i)).y;
            }
            this.minecraft.field_1772.method_27521(String.valueOf(letter.letter()), x, y, class_9848.method_61330((int)255, (int)this.textColor), false, poseStack.method_23760().method_23761(), (class_4597)this.minecraft.method_22940().method_23000(), class_327.class_6415.field_33994, 0, 0xF000F0);
        }
        source.method_22993();
    }

    public void render(class_332 guiGraphics, float partialTick) {
        Map<Integer, Vector2f> offsets = this.getTextEffectOffsets(partialTick);
        for (int i = 0; i < this.lettersRenderer.size(); ++i) {
            AbstractDialogScrollText.LetterLocation letter = (AbstractDialogScrollText.LetterLocation)this.lettersRenderer.get(i);
            if (!letter.render()) continue;
            float x = letter.x();
            float y = letter.y();
            DialogRenderer dialogRenderer = this.dialogRenderer;
            if (dialogRenderer instanceof DialogRenderer3D) {
                DialogRenderer3D dialogRenderer3D = (DialogRenderer3D)dialogRenderer;
                if (dialogRenderer3D.getDialogOffset().y < 0.0f) {
                    y += dialogRenderer3D.getTotalHeight() - dialogRenderer3D.getPaddingY();
                }
            }
            if (offsets.containsKey(i)) {
                x += offsets.get((Object)Integer.valueOf((int)i)).x;
                y += offsets.get((Object)Integer.valueOf((int)i)).y;
            }
            ((ICustomGuiRender)guiGraphics).narrativecraft$drawStringFloat(String.valueOf(letter.letter()), this.minecraft.field_1772, x, y, class_9848.method_61330((int)255, (int)this.textColor), false);
        }
    }
}

