/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.recording.RecordingData;
import fr.loudo.narrativecraft.narrative.recording.actions.ActionsData;
import fr.loudo.narrativecraft.narrative.recording.actions.GameModeAction;
import fr.loudo.narrativecraft.narrative.recording.actions.RidingAction;
import fr.loudo.narrativecraft.narrative.recording.actions.modsListeners.ModsListenerImpl;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1542;
import net.minecraft.class_1672;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3857;
import net.minecraft.class_8836;
import net.minecraft.class_9463;

public class Recording {
    private final AtomicInteger ids = new AtomicInteger();
    private final List<class_1297> trackedEntities = new ArrayList<class_1297>();
    private final List<RecordingData> recordingDataList = new ArrayList<RecordingData>();
    private final PlayerSession playerSession;
    private List<Subscene> subscenesPlaying = new ArrayList<Subscene>();
    private RecordingData entityRecorderData;
    private boolean isRecording;
    private int tick = 0;

    public Recording(class_1309 entity, PlayerSession playerSession) {
        this.entityRecorderData = new RecordingData((class_1297)entity, this);
        this.entityRecorderData.setSavingTrack(true);
        this.entityRecorderData.getActionsData().setEntityIdRecording(this.ids.incrementAndGet());
        this.isRecording = false;
        this.playerSession = playerSession;
    }

    public Recording(class_1309 entity, PlayerSession playerSession, List<Subscene> subscenes) {
        this(entity, playerSession);
        this.subscenesPlaying = subscenes;
    }

    public boolean isSameEntity(class_1297 entity) {
        return this.entityRecorderData.getEntity().method_5667().equals(entity.method_5667());
    }

    public void start() {
        if (this.isRecording) {
            return;
        }
        this.tick = 0;
        this.ids.set(0);
        this.entityRecorderData = new RecordingData(this.entityRecorderData.getEntity(), this);
        this.entityRecorderData.setSavingTrack(true);
        this.entityRecorderData.getActionsData().setEntityIdRecording(this.ids.incrementAndGet());
        this.recordingDataList.clear();
        this.trackedEntities.clear();
        this.recordingDataList.add(this.entityRecorderData);
        this.isRecording = true;
        class_1297 class_12972 = this.entityRecorderData.getEntity();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            GameModeAction gameModeAction = new GameModeAction(0, player.field_13974.method_14257(), player.field_13974.method_14257());
            this.entityRecorderData.getActionsData().addAction(gameModeAction);
        }
        for (Subscene subscene : this.subscenesPlaying) {
            subscene.start((class_1937)this.playerSession.getPlayer().method_51469(), Environment.RECORDING, false);
            this.playerSession.getPlaybackManager().getPlaybacks().addAll(subscene.getPlaybacks());
        }
    }

    public void stop() {
        if (!this.isRecording) {
            return;
        }
        this.isRecording = false;
        for (Subscene subscene : this.subscenesPlaying) {
            subscene.stop(true);
            this.playerSession.getPlaybackManager().getPlaybacks().removeAll(subscene.getPlaybacks());
        }
        this.subscenesPlaying.clear();
        for (RecordingData recordingData : this.recordingDataList) {
            if (!(recordingData.getEntity() instanceof class_1309)) continue;
            recordingData.getActionsData().reset(recordingData.getEntity());
            for (ModsListenerImpl modsListener : recordingData.getActionDifferenceListener().getModsListenerList()) {
                modsListener.stop();
            }
        }
    }

    public void save(Animation animation) throws IOException {
        if (this.isRecording) {
            return;
        }
        List<ActionsData> actionsDataList = this.recordingDataList.stream().filter(RecordingData::isSavingTrack).map(RecordingData::getActionsData).toList();
        animation.setActionsData(actionsDataList);
        NarrativeCraftFile.updateAnimationFile(animation);
        animation.getScene().addAnimation(animation);
        this.recordingDataList.clear();
    }

    public void tick() {
        ActionsData actionsData;
        List<UUID> trackedUUIDs = this.trackedEntities.stream().map(class_1297::method_5667).toList();
        List nearbyEntities = this.entityRecorderData.getEntity().method_73183().method_8335(this.entityRecorderData.getEntity(), this.entityRecorderData.getEntity().method_5829().method_1014(30.0));
        for (class_1297 entity : nearbyEntities) {
            if (trackedUUIDs.contains(entity.method_5667()) || entity instanceof class_9463 || entity instanceof class_1672 || entity instanceof class_3857) continue;
            this.trackedEntities.add(entity);
            RecordingData recordingData = new RecordingData(entity, this);
            this.recordingDataList.add(recordingData);
            if (!(entity instanceof class_8836) && !(entity instanceof class_1496) && !(entity instanceof class_1542)) continue;
            this.trackEntity(entity, this.tick);
        }
        for (RecordingData recordingData : this.recordingDataList) {
            if (this.playerSession.getPlaybackManager().entityInPlayback(recordingData.getEntity())) {
                recordingData.setSavingTrack(false);
            }
            recordingData.getActionsData().addLocation();
            recordingData.getActionDifferenceListener().listenDifference();
        }
        if (this.tick == 0 && this.entityRecorderData.getEntity().method_5854() != null && (actionsData = this.getActionDataFromEntity(this.entityRecorderData.getEntity().method_5854())) != null) {
            RidingAction action = new RidingAction(0, actionsData.getEntityIdRecording());
            this.entityRecorderData.getActionsData().addAction(action);
        }
        ++this.tick;
    }

    public ActionsData getActionDataFromEntity(class_1297 entity) {
        for (RecordingData recordingData : this.recordingDataList) {
            if (!recordingData.isSameEntity(entity)) continue;
            recordingData.setSavingTrack(true);
            return recordingData.getActionsData();
        }
        return null;
    }

    public RecordingData getRecordingDataFromEntity(class_1297 entity) {
        for (RecordingData recordingData : this.recordingDataList) {
            if (!recordingData.isSameEntity(entity)) continue;
            return recordingData;
        }
        return null;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public class_1297 getEntity() {
        return this.entityRecorderData.getEntity();
    }

    public int getTick() {
        return this.tick;
    }

    public AtomicInteger getIds() {
        return this.ids;
    }

    public boolean trackEntity(class_1297 entity) {
        RecordingData recordingData = this.getRecordingDataFromEntity(entity);
        if (recordingData == null || recordingData.isSavingTrack()) {
            return false;
        }
        recordingData.setSavingTrack(true);
        recordingData.getActionsData().setSpawnTick(0);
        recordingData.getActionsData().setEntityIdRecording(this.ids.incrementAndGet());
        return true;
    }

    public void trackEntity(class_1297 entity, int tickSpawn) {
        if (!this.trackEntity(entity)) {
            return;
        }
        RecordingData recordingData = this.getRecordingDataFromEntity(entity);
        recordingData.getActionsData().setSpawnTick(tickSpawn);
    }

    public List<Subscene> getSubscenesPlaying() {
        return this.subscenesPlaying;
    }

    public void setSubscenesPlaying(List<Subscene> subscenesPlaying) {
        this.subscenesPlaying = subscenesPlaying;
    }
}

