/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.util.InkUtil;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public class SubsceneInkAction
extends InkAction {
    private Subscene subscene;
    private String action;
    private boolean isLooping;
    private boolean isBlock;
    private boolean isUnique;

    public SubsceneInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void tick() {
        if (this.subscene == null) {
            this.isRunning = false;
            return;
        }
        if (!this.isRunning && this.blockEndTask != null) {
            this.blockEndTask.run();
            return;
        }
        this.isRunning = !this.subscene.hasEnded();
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() < 2) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Action start or stop"));
        }
        this.action = arguments.get(1);
        if (!this.action.equals("start") && !this.action.equals("stop")) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", "Only start or stop as action"));
        }
        if (arguments.size() < 3) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Subscene name"));
        }
        String subsceneName = arguments.get(2);
        this.subscene = scene.getSubsceneByName(subsceneName);
        if (this.subscene == null) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", Translation.message("subscene.no_exists", subsceneName, scene.getName())));
        }
        this.isLooping = InkUtil.getOptionalArgument(this.command, "loop");
        this.isUnique = InkUtil.getOptionalArgument(this.command, "unique");
        this.isBlock = InkUtil.getOptionalArgument(this.command, "block");
        if (arguments.size() < 4 || this.action.equals("stop")) {
            this.canBeExecuted = true;
            return InkActionResult.ok();
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        if (this.action.equals("start")) {
            StoryHandler storyHandler = playerSession.getStoryHandler();
            if (storyHandler != null) {
                this.subscene.start((class_1937)playerSession.getPlayer().method_51469(), Environment.PRODUCTION, this.isLooping, storyHandler);
            } else {
                this.subscene.start((class_1937)playerSession.getPlayer().method_51469(), Environment.PRODUCTION, this.isLooping);
            }
            for (Playback playback : this.subscene.getPlaybacks()) {
                playerSession.getCharacterRuntimes().add(playback.getCharacterRuntime());
                playback.setUnique(this.isUnique);
            }
            playerSession.clearKilledCharacters();
            playerSession.getPlaybackManager().getPlaybacks().addAll(this.subscene.getPlaybacks());
        } else if (this.action.equals("stop")) {
            for (Playback playback : this.subscene.getPlaybacks()) {
                playerSession.getCharacterRuntimes().remove(playback.getCharacterRuntime());
            }
            playerSession.getPlaybackManager().getPlaybacks().removeAll(this.subscene.getPlaybacks());
            this.subscene.stop(true);
        }
        return this.isBlock ? InkActionResult.block() : InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return true;
    }
}

