/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction.sound;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.inkAction.sound.SoundInkInstance;
import fr.loudo.narrativecraft.util.InkUtil;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class SoundInkAction
extends InkAction {
    private class_1144 soundManager;
    private class_1113 simpleSoundInstance;
    private String identifier = "minecraft";
    private String name;
    private String action;
    private Type type;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private boolean isLooping;
    private double fadeTime;

    public SoundInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void tick() {
        if (!this.soundManager.method_4877(this.simpleSoundInstance)) {
            this.isRunning = false;
        }
        if (!this.isRunning || this.totalTick == 0) {
            return;
        }
        ++this.tick;
        boolean bl = this.isRunning = this.tick <= this.totalTick || this.action.equals("start");
        if (!this.isRunning) {
            this.soundManager.method_4870(this.simpleSoundInstance);
        }
    }

    @Override
    public void partialTick(float partialTick) {
        if (!this.isRunning || this.totalTick == 0) {
            return;
        }
        double t = class_3532.method_15350((double)(((float)this.tick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
        float newVolume = 0.0f;
        if (this.action.equals("start")) {
            newVolume = (float)class_3532.method_16436((double)t, (double)0.0, (double)this.volume);
        } else if (this.action.equals("stop")) {
            newVolume = (float)class_3532.method_16436((double)t, (double)this.volume, (double)0.0);
        }
        this.soundManager.method_65258(this.simpleSoundInstance, newVolume);
        if ((double)newVolume == 0.0 && this.action.equals("stop")) {
            this.soundManager.method_4870(this.simpleSoundInstance);
        }
    }

    @Override
    public void stop() {
        if (this.soundManager == null || this.simpleSoundInstance == null) {
            return;
        }
        this.soundManager.method_4870(this.simpleSoundInstance);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        class_2960 location;
        class_310 minecraft = class_310.method_1551();
        this.soundManager = minecraft.method_1483();
        if (arguments.size() == 1) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Start or stop"));
        }
        String typeName = arguments.getFirst();
        this.type = Type.valueOf(typeName.toUpperCase());
        this.action = arguments.get(1);
        if (!this.action.equals("start") && !this.action.equals("stop")) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", "Only start or stop action"));
        }
        if (arguments.size() == 2) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", this.type.name().toLowerCase() + " name"));
        }
        this.name = arguments.get(2);
        if (this.action.equals("stop") && this.name.equals("all")) {
            return InkActionResult.ok();
        }
        if (this.name.contains(":")) {
            String[] splitName = this.name.split(":");
            this.identifier = splitName[0];
            this.name = splitName[1];
        }
        if (this.soundManager.method_4869(location = class_2960.method_60655((String)this.identifier, (String)this.name)) == null) {
            return InkActionResult.warn((class_2561)Translation.message("ink_action.validation.sound", this.type.name().toLowerCase(), this.name));
        }
        if (this.action.equals("start") && arguments.size() > 3) {
            this.isLooping = InkUtil.getOptionalArgument(this.command, "loop");
            try {
                this.volume = Float.parseFloat(arguments.get(3));
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(3)));
            }
            if (arguments.size() == 4) {
                return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "pitch"));
            }
            try {
                this.pitch = Float.parseFloat(arguments.get(4));
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(4)));
            }
            if (arguments.size() == 5) {
                return InkActionResult.ok();
            }
            String fadeValue = arguments.get(5);
            if (!fadeValue.equals("fadein")) {
                return InkActionResult.ok();
            }
            if (arguments.size() == 6) {
                return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "fade in value"));
            }
            try {
                this.fadeTime = Double.parseDouble(arguments.get(6));
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(6)));
            }
            this.simpleSoundInstance = this.getSimpleSoundInstance();
            this.soundManager.method_4873(this.simpleSoundInstance);
            if (this.fadeTime > 0.0) {
                this.soundManager.method_65258(this.simpleSoundInstance, 0.0f);
            }
        } else if (this.action.equals("stop") && arguments.size() > 3) {
            String fadeValue = arguments.get(3);
            if (!fadeValue.equals("fadeout")) {
                return InkActionResult.ok();
            }
            if (arguments.size() == 4) {
                return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "fade out value"));
            }
            try {
                this.fadeTime = Double.parseDouble(arguments.get(4));
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(4)));
            }
        }
        this.totalTick = (int)(this.fadeTime * 20.0);
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        if (this.action.equals("start")) {
            this.simpleSoundInstance = this.getSimpleSoundInstance();
            this.soundManager.method_4873(this.simpleSoundInstance);
            if (this.fadeTime > 0.0) {
                this.soundManager.method_65258(this.simpleSoundInstance, 0.0f);
            }
        } else if (this.action.equals("stop")) {
            for (InkAction inkAction : playerSession.getInkActions()) {
                boolean matchOne;
                if (!(inkAction instanceof SoundInkAction)) continue;
                SoundInkAction soundInkAction = (SoundInkAction)inkAction;
                boolean matchAll = this.name.equals("all") && (soundInkAction.type == this.type || this.type == Type.SOUND);
                boolean bl = matchOne = !this.name.equals("all") && soundInkAction.name.equals(this.name) && this.type == soundInkAction.type;
                if (matchAll || matchOne) {
                    soundInkAction.isRunning = false;
                }
                if (matchAll) {
                    this.isRunning = false;
                    soundInkAction.stop();
                    continue;
                }
                if (!matchOne) continue;
                if (this.fadeTime > 0.0) {
                    this.simpleSoundInstance = soundInkAction.simpleSoundInstance;
                    this.volume = soundInkAction.volume;
                    continue;
                }
                this.isRunning = false;
                soundInkAction.stop();
            }
        }
        return InkActionResult.ok();
    }

    private class_1113 getSimpleSoundInstance() {
        if (this.simpleSoundInstance == null) {
            this.simpleSoundInstance = new SoundInkInstance(class_2960.method_60655((String)this.identifier, (String)this.name), class_3419.field_15250, this.volume, this.pitch, class_1113.method_43221(), this.isLooping, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true);
        }
        return this.simpleSoundInstance;
    }

    @Override
    public boolean needScene() {
        return false;
    }

    public static enum Type {
        SFX,
        SONG,
        SOUND;

    }
}

