/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction.text;

import fr.loudo.narrativecraft.gui.ICustomGuiRender;
import fr.loudo.narrativecraft.narrative.dialog.animation.AbstractDialogScrollText;
import fr.loudo.narrativecraft.narrative.story.inkAction.text.Attribute;
import fr.loudo.narrativecraft.narrative.story.inkAction.text.Position;
import fr.loudo.narrativecraft.narrative.story.inkAction.text.TextInkAction;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_11719;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_9848;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;

public class DialogScrollTextInkAction
extends AbstractDialogScrollText {
    private final TextInkAction textInkAction;
    private boolean isBlock;
    private int endAt;

    public DialogScrollTextInkAction(class_310 minecraft, TextInkAction textInkAction) {
        super(minecraft);
        this.textInkAction = textInkAction;
    }

    @Override
    protected List<String> splitTextIntoLines(String text) {
        Attribute attribute = this.textInkAction.getAttribute();
        return Util.splitText(text, this.minecraft.field_1772, attribute.getWidth());
    }

    @Override
    protected float getInitialX() {
        return 0.0f;
    }

    @Override
    protected float getInitialY() {
        return 0.0f;
    }

    @Override
    protected boolean canScroll() {
        return true;
    }

    public int getEndAt() {
        return this.endAt;
    }

    public void setEndAt(int endAt) {
        this.endAt = endAt;
    }

    public void render(class_332 guiGraphics, float partialTick, double opacity) {
        Attribute attribute = this.textInkAction.getAttribute();
        if (!attribute.isRender()) {
            return;
        }
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        class_327 font = attribute.getFont();
        Position position = attribute.getPosition();
        class_5250 longerText = class_2561.method_43470((String)this.getLongerTextLine()).method_27694(style -> {
            if (attribute.getCustomFont() == null) {
                return style;
            }
            return style.method_27704((class_11719)new class_11719.class_11721(attribute.getCustomFont()));
        });
        int textWidth = font.method_30880(longerText.method_30937());
        Objects.requireNonNull(font);
        int textHeight = 9;
        float centerX = (float)guiGraphics.method_51421() / 2.0f;
        float centerY = (float)guiGraphics.method_51443() / 2.0f;
        float totalHeight = textHeight * this.lines.size();
        float anchorX = 0.0f;
        float anchorY = 0.0f;
        float textOffsetX = 0.0f;
        float textOffsetY = 0.0f;
        switch (position) {
            case TOP: {
                anchorX = centerX;
                anchorY = 0.0f;
                textOffsetX = (float)(-textWidth) / 2.0f;
                textOffsetY = 0.0f;
                break;
            }
            case TOP_LEFT: {
                anchorX = 0.0f;
                anchorY = 0.0f;
                textOffsetX = 0.0f;
                textOffsetY = 0.0f;
                break;
            }
            case TOP_RIGHT: {
                anchorX = guiGraphics.method_51421();
                anchorY = 0.0f;
                textOffsetX = -textWidth;
                textOffsetY = 0.0f;
                break;
            }
            case MIDDLE: {
                anchorX = centerX;
                anchorY = centerY;
                textOffsetX = (float)(-textWidth) / 2.0f;
                textOffsetY = -totalHeight / 2.0f;
                break;
            }
            case MIDDLE_LEFT: {
                anchorX = 0.0f;
                anchorY = centerY;
                textOffsetX = 0.0f;
                textOffsetY = -totalHeight / 2.0f;
                break;
            }
            case MIDDLE_RIGHT: {
                anchorX = guiGraphics.method_51421();
                anchorY = centerY;
                textOffsetX = -textWidth;
                textOffsetY = -totalHeight / 2.0f;
                break;
            }
            case BOTTOM: {
                anchorX = centerX;
                anchorY = guiGraphics.method_51443();
                textOffsetX = (float)(-textWidth) / 2.0f;
                textOffsetY = -totalHeight;
                break;
            }
            case BOTTOM_LEFT: {
                anchorX = 0.0f;
                anchorY = guiGraphics.method_51443();
                textOffsetX = 0.0f;
                textOffsetY = -totalHeight;
                break;
            }
            case BOTTOM_RIGHT: {
                anchorX = guiGraphics.method_51421();
                anchorY = guiGraphics.method_51443();
                textOffsetX = -textWidth;
                textOffsetY = -totalHeight;
            }
        }
        float[] spacing = attribute.getSpacing();
        if (spacing == null) {
            spacing = new float[]{0.0f, 0.0f};
        }
        poseStack.pushMatrix();
        poseStack.translate(anchorX + spacing[0], anchorY + spacing[1]);
        poseStack.scale(attribute.getScale(), attribute.getScale());
        poseStack.translate(textOffsetX, textOffsetY);
        Map<Integer, Vector2f> offsets = this.getTextEffectOffsets(partialTick);
        for (int i = 0; i < this.lettersRenderer.size(); ++i) {
            AbstractDialogScrollText.LetterLocation letter = (AbstractDialogScrollText.LetterLocation)this.lettersRenderer.get(i);
            if (!letter.render()) continue;
            float x = letter.x();
            float y = letter.y();
            if (offsets.containsKey(i)) {
                x += offsets.get((Object)Integer.valueOf((int)i)).x;
                y += offsets.get((Object)Integer.valueOf((int)i)).y;
            }
            ((ICustomGuiRender)guiGraphics).narrativecraft$drawStringFloat(String.valueOf(letter.letter()), font, x, y, class_9848.method_61330((int)((int)(opacity * 255.0)), (int)this.textInkAction.getAttribute().getColor()), attribute.isDropShadow());
        }
        poseStack.popMatrix();
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public void setBlock(boolean block) {
        this.isBlock = block;
    }
}

