/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.keyframe;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionRegistry;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.controllers.mainScreen.MainScreenController;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import fr.loudo.narrativecraft.narrative.story.inkAction.OnEnterInkAction;
import fr.loudo.narrativecraft.narrative.story.inkAction.SaveInkAction;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7842;

public class KeyframeTriggerScreen
extends class_437 {
    private final int gap = 5;
    private final int tickBoxHeight = 20;
    private final int tickBoxWidth = 60;
    private final int commandBoxHeight = 120;
    private final int globalWidth = 240;
    private int defaultTick;
    private ScreenUtils.LabelBox tickBox;
    private ScreenUtils.MultilineLabelBox commandBox;
    private AbstractKeyframeController<? extends Keyframe> controller;
    private KeyframeTrigger keyframeTrigger;

    public KeyframeTriggerScreen(AbstractKeyframeController<? extends Keyframe> controller, KeyframeTrigger keyframeTrigger) {
        super((class_2561)class_2561.method_43470((String)"Keyframe Trigger Screen"));
        this.controller = controller;
        this.keyframeTrigger = keyframeTrigger;
        this.defaultTick = keyframeTrigger.getTick();
    }

    public KeyframeTriggerScreen(AbstractKeyframeController<? extends Keyframe> controller, int defaultTick) {
        super((class_2561)class_2561.method_43470((String)"Keyframe Trigger Screen"));
        this.controller = controller;
        this.defaultTick = defaultTick;
    }

    protected void method_25426() {
        int totalHeight = 195;
        if (this.keyframeTrigger != null) {
            totalHeight += 45;
        }
        int startY = (this.field_22790 - totalHeight) / 2;
        int xGlobal = (this.field_22789 - 240) / 2;
        Objects.requireNonNull(this.field_22787.field_1772);
        class_7842 tagWidget = new class_7842(0, startY - 9 - 30, 100, 40, (class_2561)class_2561.method_43473(), this.field_22787.field_1772);
        this.method_37063((class_364)tagWidget);
        Objects.requireNonNull(this.field_22787.field_1772);
        class_7842 errorWidget = new class_7842(0, startY - 9 - 20, 100, 40, (class_2561)class_2561.method_43473(), this.field_22787.field_1772);
        this.method_37063((class_364)errorWidget);
        int currentY = startY;
        this.tickBox = new ScreenUtils.LabelBox((class_2561)class_2561.method_43470((String)"Tick"), this.field_22787.field_1772, 60, 20, xGlobal, currentY, ScreenUtils.Align.HORIZONTAL);
        this.tickBox.getEditBox().method_1890(s -> s.matches("^(?:[0-9]+)?$"));
        this.method_37063((class_364)this.tickBox.getStringWidget());
        this.method_37063((class_364)this.tickBox.getEditBox());
        this.commandBox = new ScreenUtils.MultilineLabelBox((class_2561)class_2561.method_43470((String)"Tags"), this.field_22787.field_1772, 240, 120, xGlobal, currentY += 25, (class_2561)class_2561.method_43470((String)"animation start cathy_walk\ntime set 6000 to 90000 for 6 seconds\n..."));
        this.method_37063((class_364)this.commandBox.getStringWidget());
        this.method_37063((class_364)this.commandBox.getMultiLineEditBox());
        class_4185 doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            List<String> tags = Arrays.asList(this.commandBox.getMultiLineEditBox().method_44405().split("\n"));
            for (String tag : tags) {
                String stringTag = "\"" + tag + "\"";
                int tagWidth = this.field_22787.field_1772.method_1727(stringTag);
                tagWidget.method_25358(tagWidth);
                tagWidget.method_46421(this.field_22789 / 2 - tagWidth / 2);
                InkAction inkAction = InkActionRegistry.findByCommand(tag);
                if (inkAction instanceof SaveInkAction || inkAction instanceof OnEnterInkAction) {
                    this.showError(tagWidget, errorWidget, stringTag, (class_2561)Translation.message("ink_action.not_authorized", stringTag));
                    return;
                }
                if (inkAction == null) {
                    this.showError(tagWidget, errorWidget, stringTag, (class_2561)Translation.message("ink_action.no_exists", new Object[0]));
                    return;
                }
                if (this.controller instanceof MainScreenController && inkAction.needScene()) {
                    this.showError(tagWidget, errorWidget, stringTag, (class_2561)Translation.message("ink_action.not_authorized", stringTag));
                    return;
                }
                InkActionResult result = inkAction.validate(tag, this.controller.getPlayerSession().getScene());
                if (!result.isError()) continue;
                this.showError(tagWidget, errorWidget, stringTag, (class_2561)class_2561.method_43470((String)result.errorMessage()));
                return;
            }
            int tick = this.defaultTick;
            try {
                tick = Integer.parseInt(this.tickBox.getEditBox().method_1882());
            }
            catch (NumberFormatException tag) {
                // empty catch block
            }
            String commands = this.commandBox.getMultiLineEditBox().method_44405();
            if (this.keyframeTrigger == null) {
                this.controller.addKeyframeTrigger(tick, commands);
            } else {
                this.keyframeTrigger.setTick(tick);
                this.keyframeTrigger.setCommands(commands);
            }
            this.method_25419();
        }).method_46432(240).method_46433(xGlobal, currentY += 120 + this.commandBox.getStringWidget().method_25364() + 10).method_46431();
        this.method_37063((class_364)doneButton);
        class_4185 closeButton = class_4185.method_46430((class_2561)Translation.message("global.close", new Object[0]), button -> this.method_25419()).method_46432(240).method_46433(xGlobal, currentY += 25).method_46431();
        this.method_37063((class_364)closeButton);
        if (this.keyframeTrigger != null) {
            class_4185 removeButton = class_4185.method_46430((class_2561)Translation.message("global.remove", new Object[0]), button -> {
                class_410 confirmScreen = new class_410(b -> {
                    if (b) {
                        this.controller.removeKeyframeTrigger(this.keyframeTrigger);
                        this.method_25419();
                    } else {
                        KeyframeTriggerScreen screen = new KeyframeTriggerScreen(this.controller, this.keyframeTrigger);
                        this.field_22787.method_1507((class_437)screen);
                    }
                }, (class_2561)class_2561.method_43470((String)""), (class_2561)Translation.message("global.confirm_delete", new Object[0]), class_5244.field_24336, class_5244.field_24335);
                this.field_22787.method_1507((class_437)confirmScreen);
            }).method_46432(240).method_46433(xGlobal, currentY += 25).method_46431();
            this.method_37063((class_364)removeButton);
        }
        if (this.keyframeTrigger != null) {
            this.tickBox.getEditBox().method_1852(String.valueOf(this.keyframeTrigger.getTick()));
            this.commandBox.getMultiLineEditBox().method_44400(this.keyframeTrigger.getCommands());
        } else {
            this.tickBox.getEditBox().method_1852(String.valueOf(this.defaultTick));
        }
    }

    private void showError(class_7842 tagWidget, class_7842 errorWidget, String stringTag, class_2561 errorMessage) {
        tagWidget.method_25355((class_2561)class_2561.method_43470((String)stringTag).method_27692(class_124.field_1061));
        errorWidget.method_25355((class_2561)errorMessage.method_27661().method_27692(class_124.field_1061));
        int errorWidth = this.field_22787.field_1772.method_27525((class_5348)errorMessage);
        errorWidget.method_25358(errorWidth);
        errorWidget.method_46421(this.field_22789 / 2 - errorWidth / 2);
    }
}

