/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.character;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.CharacterManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.CameraAngle;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.screens.characters.CharacterEntityTypeScreen;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.character.EditScreenCharacterAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class CharactersScreen
extends StoryElementScreen {
    private final Scene scene;

    public CharactersScreen(Scene scene) {
        super((class_2561)(scene == null ? Translation.message("screen.story_manager.characters", new Object[0]) : Translation.message("screen.story_manager.npcs", scene.getName())));
        this.scene = scene;
    }

    public void method_25419() {
        if (this.scene != null) {
            this.field_22787.method_1507((class_437)new ScenesMenuScreen(this.scene));
        } else {
            super.method_25419();
        }
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<CharacterStory> screen = new EditInfoScreen<CharacterStory>(this, null, new EditScreenCharacterAdapter(this.scene));
            this.field_22787.method_1507(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addContents() {
        CharacterManager characterManager = NarrativeCraftMod.getInstance().getCharacterManager();
        List<CharacterStory> characterStories = this.scene == null ? characterManager.getCharacterStories().stream().filter(characterStory -> !characterStory.getMainCharacterAttribute().isMainCharacter()).collect(Collectors.toList()) : this.scene.getNpcs();
        CharacterStory mainCharacter = characterManager.getMainCharacter();
        if (mainCharacter != null && this.scene == null) {
            characterStories.addFirst(mainCharacter);
        }
        List<StoryElementList.StoryEntryData> entries = characterStories.stream().map(character -> {
            Object name = character.getName();
            if (character.getMainCharacterAttribute().isMainCharacter()) {
                name = (String)name + " (" + Translation.message("global.main", new Object[0]).getString() + ")";
            }
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)name), button1 -> {}).method_46431();
            button.field_22763 = false;
            class_4185 entityTypeButton = class_4185.method_46430((class_2561)ImageFontConstants.ENTITY, button1 -> {
                CharacterEntityTypeScreen screen = new CharacterEntityTypeScreen(this, (CharacterStory)character, this.scene);
                this.field_22787.method_1507((class_437)screen);
            }).method_46431();
            entityTypeButton.method_47400(class_7919.method_47407((class_2561)Translation.message("tooltip.character_entity_type", new Object[0])));
            return new StoryElementList.StoryEntryData(button, List.of(entityTypeButton), () -> this.field_22787.method_1507(new EditInfoScreen<CharacterStory>(this, (CharacterStory)character, new EditScreenCharacterAdapter(this.scene))), () -> {
                if (this.scene == null) {
                    try {
                        if (character.getMainCharacterAttribute().isMainCharacter()) {
                            CharacterStory newMainCharacter = characterManager.getCharacterStories().get(0);
                            newMainCharacter.getMainCharacterAttribute().setMainCharacter(true);
                            NarrativeCraftFile.updateCharacterData(newMainCharacter, newMainCharacter);
                        }
                        NarrativeCraftFile.deleteCharacterFolder(character);
                        characterManager.removeCharacter((CharacterStory)character);
                    }
                    catch (Exception e) {
                        Util.sendCrashMessage((class_1657)this.field_22787.field_1724, e);
                        this.field_22787.method_1507(null);
                    }
                } else {
                    this.scene.removeNpc((CharacterStory)character);
                    NarrativeCraftFile.deleteCharacterFolder(character, this.scene);
                }
                try {
                    for (Chapter chapter : NarrativeCraftMod.getInstance().getChapterManager().getChapters()) {
                        for (Scene scene1 : chapter.getSortedSceneList()) {
                            for (Animation animation : scene1.getAnimations()) {
                                if (!animation.getCharacter().getName().equalsIgnoreCase(character.getName())) continue;
                                animation.setCharacter(null);
                                NarrativeCraftFile.updateAnimationFile(animation);
                            }
                            for (CameraAngle cameraAngle : scene1.getCameraAngles()) {
                                cameraAngle.getCharacterStoryDataList().removeIf(characterStoryData -> characterStoryData.getCharacterStory().getName().equalsIgnoreCase(character.getName()));
                            }
                            NarrativeCraftFile.updateCameraAngles(scene1);
                        }
                    }
                }
                catch (Exception e) {
                    Util.sendCrashMessage((class_1657)this.field_22787.field_1724, e);
                    this.field_22787.method_1507(null);
                    return;
                }
                this.field_22787.method_1507((class_437)new CharactersScreen(this.scene));
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.method_48999((class_8021)new StoryElementList(this.field_22787, this, entries, true));
    }

    @Override
    protected void openFolder() {
        if (this.scene == null) {
            class_156.method_668().method_60932(NarrativeCraftFile.characterDirectory.toPath());
        } else {
            class_156.method_668().method_60932(NarrativeCraftFile.getNpcFolder(this.scene).toPath());
        }
    }
}

