/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording;

import fr.loudo.narrativecraft.narrative.recording.Recording;
import fr.loudo.narrativecraft.narrative.recording.actions.ActionsData;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionDifferenceListener;
import net.minecraft.world.entity.Entity;

public class RecordingData {
    private final Entity entity;
    private final ActionDifferenceListener actionDifferenceListener;
    private final ActionsData actionsData;
    private boolean savingTrack;

    public RecordingData(Entity entity, Recording recording) {
        this.entity = entity;
        this.actionsData = new ActionsData(entity, recording.getTick());
        this.actionDifferenceListener = new ActionDifferenceListener(this.actionsData, recording);
        this.savingTrack = false;
    }

    public boolean isSameEntity(Entity entity) {
        return this.entity.getUUID().equals(entity.getUUID());
    }

    public Entity getEntity() {
        return this.entity;
    }

    public ActionDifferenceListener getActionDifferenceListener() {
        return this.actionDifferenceListener;
    }

    public ActionsData getActionsData() {
        return this.actionsData;
    }

    public boolean isSavingTrack() {
        return this.savingTrack;
    }

    public void setSavingTrack(boolean savingTrack) {
        this.savingTrack = savingTrack;
    }
}

