/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.BreakBlockAction;
import fr.loudo.narrativecraft.narrative.recording.actions.PlaceBlockAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;

public class ActionsData {
    private transient Entity entity;
    private final int entityId;
    private int entityIdRecording;
    private int spawnTick;
    private String nbtData;
    private final List<Location> locations = new ArrayList<Location>();
    private final List<Action> actions = new ArrayList<Action>();

    public ActionsData(Entity entity, int spawnTick) {
        this.entity = entity;
        if (!(entity instanceof ServerPlayer)) {
            this.nbtData = String.valueOf(this.serializeNBT());
        }
        this.entityId = BuiltInRegistries.ENTITY_TYPE.getId((Object)entity.getType());
        this.spawnTick = spawnTick;
        this.entityIdRecording = -1;
    }

    private CompoundTag serializeNBT() {
        TagValueOutput nbt = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)this.entity.registryAccess());
        this.entity.saveWithoutId((ValueOutput)nbt);
        CompoundTag compoundTag = nbt.buildResult();
        compoundTag.remove("UUID");
        compoundTag.remove("Pos");
        compoundTag.remove("Motion");
        return compoundTag;
    }

    public void addLocation() {
        Location currentLoc = new Location(this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.entity.getXRot(), this.entity.getYRot(), this.entity.onGround());
        this.locations.add(currentLoc);
    }

    public void reset(Entity entity) {
        PlaybackData playbackData = new PlaybackData(this, null);
        playbackData.setEntity(entity);
        HashMap<BlockPos, Action> latestActions = new HashMap<BlockPos, Action>();
        for (Action action : this.actions) {
            BlockPos pos = this.getPosFromAction(action);
            if (pos == null) continue;
            latestActions.putIfAbsent(pos, action);
        }
        for (Map.Entry entry : latestActions.entrySet()) {
            Action action = (Action)entry.getValue();
            if (action instanceof PlaceBlockAction) {
                PlaceBlockAction place = (PlaceBlockAction)action;
                place.rewind(playbackData);
                continue;
            }
            if (!(action instanceof BreakBlockAction)) continue;
            BreakBlockAction breakBlockAction = (BreakBlockAction)action;
            breakBlockAction.rewind(playbackData);
        }
    }

    private BlockPos getPosFromAction(Action action) {
        if (action instanceof PlaceBlockAction) {
            PlaceBlockAction p = (PlaceBlockAction)action;
            return p.getBlockPos();
        }
        if (action instanceof BreakBlockAction) {
            BreakBlockAction b = (BreakBlockAction)action;
            return b.getBlockPos();
        }
        return null;
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(LivingEntity entity) {
        this.entity = entity;
    }

    public int getSpawnTick() {
        return this.spawnTick;
    }

    public void setSpawnTick(int spawnTick) {
        this.spawnTick = spawnTick;
    }

    public int getEntityIdRecording() {
        return this.entityIdRecording;
    }

    public void setEntityIdRecording(int entityIdRecording) {
        this.entityIdRecording = entityIdRecording;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getNbtData() {
        return this.nbtData;
    }
}

