/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.network.chat.Component;

public class KillCharacterInkAction
extends InkAction {
    private CharacterStory characterStory;

    public KillCharacterInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Character name"));
        }
        String characterName = arguments.get(1);
        this.characterStory = NarrativeCraftMod.getInstance().getCharacterManager().getCharacterByName(characterName);
        if (this.characterStory == null && scene != null) {
            this.characterStory = scene.getNpcByName(characterName);
        }
        if (this.characterStory == null) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Character " + characterName + " does not exists."));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            return InkActionResult.ignored();
        }
        if (!storyHandler.characterInStory(this.characterStory)) {
            return InkActionResult.ignored();
        }
        storyHandler.killCharacter(this.characterStory);
        return InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

